<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\View\Helper;

use Laminas\View\Helper\AbstractHelper;

class HelpUrl extends AbstractHelper
{

    const HELP_URL  = 'https://docs.loongdomsoft.com/dbshop/';
    const URL_STATE = true;

    /**
     * 帮助网址
     * @param $name
     * @return false|string
     */
    public function __invoke($name)
    {
        if(!self::URL_STATE) return '';

        $urlArray = [
            /*=====================系统========================*/
            'system'                => 'system/',

            'adminList'             => 'system/admin.html',
            'adminAdd'              => 'system/admin.html#管理员添加',
            'adminEdit'             => 'system/admin.html#管理员编辑',
            'adminPassword'         => 'system/admin.html#管理员密码修改',

            'adminGroupList'        => 'system/admin-group.html',
            'adminGroupAdd'         => 'system/admin-group.html#管理员组添加',
            'adminGroupEdit'        => 'system/admin-group.html#管理员组编辑',

            'customerSet'           => 'system/customer.html',

            'regionList'            => 'system/region.html',
            'regionAdd'             => 'system/region.html#地区添加',
            'regionEdit'            => 'system/region.html#地区编辑',

            'paymentList'           => 'system/payment.html',
            'Alipay'                => 'system/payment.html#支付宝支付',
            'BalancePay'            => 'system/payment.html#余额支付',
            'CashOnDelivery'        => 'system/payment.html#货到付款',
            'PayPal'                => 'system/payment.html#paypal国际支付',
            'Wxpay'                 => 'system/payment.html#微信支付',

            'currencyList'          => 'system/currency.html',
            'currencyAdd'           => 'system/currency.html#货币添加',
            'currencyEdit'          => 'system/currency.html#货币编辑',

            'phoneAreaList'         => 'system/phone-area.html',
            'phoneAreaAdd'          => 'system/phone-area.html#国际电话区号添加',

            'uploadSet'             => 'system/upload.html',

            'phoneMessage'          => 'system/message.html#手机短信提醒',
            'emailMessage'          => 'system/message.html#订单提醒',

            'shopDelivery'          => 'system/delivery.html#商家配送设置',
            'deliveryList'          => 'system/delivery.html#配送列表',
            'deliveryAdd'           => 'system/delivery.html#配送添加',
            'deliveryEdit'          => 'system/delivery.html#配送编辑',
            'selfLocationList'      => 'system/delivery.html#自提点列表',
            'selfLocationAdd'       => 'system/delivery.html#自提点添加',

            'serviceBind'           => 'system/service-bind.html',      //模板管理
            'template'              => 'system/template.html',          //模板管理
            'shopUpdate'            => 'system/update.html',            //系统更新
            'operLogList'           => 'system/log.html',               //操作日志

            /*=====================销售========================*/
            'orderList'             => 'sales/',                        //订单列表
            'orderDetail'           => 'sales/#订单列表',
            'cancelOrder'           => 'sales/#取消订单',
            'payOrder'              => 'sales/#订单付款',
            'shipOrder'             => 'sales/#订单发货',
            'sendOrderGoodsVirtual' => 'sales/#订单虚拟商品发货',
            'receiptOrder'          => 'sales/#订单收货',
            'changeOrderAmount'     => 'sales/#订单金额调整',
            'editExpressNumber'     => 'sales/#订单快递单号修改',

            'orderShipList'         => 'sales/sales-ship.html',         //发货单

            'salesService'          => 'sales/sales-service.html',      //售后管理

            'orderPaymentLog'       => 'sales/payment-log.html',        //订单支付记录

            /*=====================商品========================*/
            'goodsList'             => 'goods/',
            'goodsAdd'              => 'goods/#商品添加',
            'editVirtualGoods'      => 'goods/#虚拟商品查看与补货',

            'goodsClassList'        => 'goods/class.html',
            'goodsClassAdd'         => 'goods/class.html#分类添加',

            'goodsBrandList'        => 'goods/brand.html',
            'goodsBrandAdd'         => 'goods/brand.html#品牌添加',

            'goodsCommonList'       => 'goods/goods-common.html',
            'goodsCommonAdd'        => 'goods/goods-common.html#通用内容添加',

            'goodsAttributeGroup'   => 'goods/goods-attribute.html#商品属性分组',
            'goodsAttribute'        => 'goods/goods-attribute.html#商品属性-2',
            'goodsAttributeValue'   => 'goods/goods-attribute.html#属性值设置',

            'goodsTagGroup'         => 'goods/goods-tag.html#商品标签分组',
            'goodsTag'              => 'goods/goods-tag.html#普通商品标签',
            'goodsSpecTag'          => 'goods/goods-tag.html#特定商品标签',

            'consultList'           => 'goods/goods-evaluation.html',
            'evaluationList'        => 'goods/goods-consult.html',

            /*=====================客户========================*/
            'userList'              => 'user/',
            'userAdd'               => 'user/#客户添加',

            'userGroupList'         => 'user/user-group.html',
            'userGroupAdd'          => 'user/user-group.html#客户组添加',

            'editUserBalance'       => 'user/#余额调整',
            'userBalanceLogList'    => 'user/balance.html',
            'userRechargeList'      => 'user/balance.html#充值列表',
            'userWithdrawList'      => 'user/balance.html#提现列表',

            'userIntegralType'      => 'user/integral.html',
            'editUserIntegral'      => 'user/#积分调整',
            'userIntegralLogList'   => 'user/integral.html#积分记录',
            'userIntegralRule'      => 'user/integral.html#积分规则',

            /*=====================文章========================*/
            'cmsList'               => 'cms/',
            'cmsAdd'                => 'cms/#文章添加',

            'cmsClass'              => 'cms/cms-class.html',

            'cmsSingle'             => 'cms/cms-single.html',

            /*=====================运营========================*/
            'discountRule'          => 'operation/',                    //优惠促销
            'coupon'                => 'operation/coupon.html',         //优惠券
            'rechargeCode'          => 'operation/recharge-code.html',  //充值码
            'pcAd'                  => 'operation/ad.html#电脑端广告',
            'mobileAd'              => 'operation/ad.html#手机端广告',

            /*=====================扩展========================*/
            'shopExtend'            => 'extend/#已安装插件',
            'pluginList'            => 'extend/#安装扩展插件',

            'navigationList'        => 'extend/navigation.html',        //导航设置
            'onlineService'         => 'extend/online-service.html',    //在线客服

            /*=====================统计========================*/
            'userStatistics'        => 'analysis/',                     //客户统计
            'userRanking'           => 'analysis/user-ranking.html',    //客户排行
            'orderStatistics'       => 'analysis/order.html',           //订单统计
            'salesStatistics'       => 'analysis/sales.html',           //销售情况
            'salesRanking'          => 'analysis/sales-ranking.html',   //销售排行
        ];

        if(!isset($urlArray[$name])) return false;
        $url = '<a href="'.self::HELP_URL.$urlArray[$name].'" target="_blank" class="btn btn-info btn-sm"><i class="fa fa-info-circle"></i> '.$this->getView()->plugin('translate')('查看帮助').'</a>';

        return $url;
    }
}