<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\View\Helper;

use Admin\Data\Config;
use Laminas\I18n\View\Helper\CurrencyFormat;

class ShopCurrencyFormatHelper extends CurrencyFormat
{
    public function __invoke(
        $number,
        $pattern = null,
        $currencyCode = null,
        $showDecimals = null,
        $locale = null

    )
    {
        if (null === $locale) {
            $locale = Config::SHOP_CURRENCY_LOCALE;
        }
        if (null === $currencyCode) {
            $currencyCode = Config::SHOP_CURRENCY_CODE;
        }
        if (null === $showDecimals) {
            $showDecimals = 2;
        }
        if (null === $pattern) {
            $pattern = $this->getCurrencyPattern();
        }

        if($number == 0.00) return 0;

        return parent::__invoke($number, $currencyCode, $showDecimals, $locale, $pattern);
    }
}