<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Analysis;

use Analysis\Controller\IndexController;

return [
    'Analysis' => [
        'name' => '统计',
        'controllers' => [
            IndexController::class => [
                'name' => '统计',
                'action' => ['index', 'userRanking', 'orderStatistics', 'salesStatistics', 'salesRanking'],
                'actionNames' => [
                    'index'             => '客户统计',
                    'userRanking'       => '客户排行',
                    'orderStatistics'   => '订单统计',
                    'salesStatistics'   => '销售情况',
                    'salesRanking'      => '销售排行'
                ]
            ]
        ]
    ]
];