<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms;

use Admin\Data\Config;
use Cms\Controller\CmsClassController;
use Cms\Controller\CmsSingleController;
use Cms\Controller\Factory\CmsClassControllerFactory;
use Cms\Controller\Factory\CmsSingleControllerFactory;
use Cms\Controller\Factory\IndexControllerFactory;
use Cms\Controller\IndexController;
use Cms\Plugin\CmsPlugin;
use Cms\Plugin\Factory\CmsPluginFactory;
use Cms\Service\CmsClassManager;
use Cms\Service\CmsManager;
use Cms\Service\Factory\CmsClassManagerFactory;
use Cms\Service\Factory\CmsManagerFactory;
use Cms\Service\Factory\SingleCmsManagerFactory;
use Cms\Service\SingleCmsManager;
use Cms\View\CmsHelper;
use Cms\View\Factory\CmsHelperFactory;
use Doctrine\ORM\Mapping\Driver\AnnotationDriver;
use Laminas\Router\Http\Segment;

return [
    'router' => [
        'routes' => [
            //文章
            'cms' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/cms[/:action[/:id]]',
                    'defaults' => [
                        'controller' => IndexController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //文章分类
            'cms-class' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/cms-class[/:action[/:id]]',
                    'defaults' => [
                        'controller' => CmsClassController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //单页文章
            'cms-single' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/cms-single[/:action[/:id]]',
                    'defaults' => [
                        'controller' => CmsSingleController::class,
                        'action'    => 'index'
                    ]
                ]
            ],
        ]

    ],

    'controllers' => [
        'factories' => [
            IndexController::class      => IndexControllerFactory::class,
            CmsClassController::class   => CmsClassControllerFactory::class,
            CmsSingleController::class  => CmsSingleControllerFactory::class
        ]
    ],

    'service_manager' => [
        'factories' => [
            CmsClassManager::class  => CmsClassManagerFactory::class,
            CmsManager::class       => CmsManagerFactory::class,
            SingleCmsManager::class => SingleCmsManagerFactory::class
        ]
    ],

    'listeners' => [],

    'permission_filter' => include __DIR__ . '/permission.php',

    'controller_plugins' => [
        'factories' => [
            CmsPlugin::class => CmsPluginFactory::class
        ],
        'aliases'   => [
            'cmsPlugin' => CmsPlugin::class
        ]
    ],

    'view_helpers' => [
        'factories' => [
            CmsHelper::class => CmsHelperFactory::class
        ],
        'aliases' => [
            'cmsHelper' => CmsHelper::class
        ],
    ],

    'translator' => [
        'translation_file_patterns' => [
            [
                'type' => 'gettext',
                'base_dir' => __DIR__ . '/../data/language',
                'pattern' => '%s.mo'
            ]
        ]
    ],

    'view_manager' => [
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ]
    ],

    'doctrine' => [
        'driver' => [
            __NAMESPACE__ . '_driver' => [
                'class' => AnnotationDriver::class,
                'cache' => 'array',
                'paths' => [__DIR__ . '/../src/Entity']
            ],
            'orm_default' => [
                'drivers' => [
                    __NAMESPACE__ . '\Entity' => __NAMESPACE__ . '_driver'
                ]
            ]
        ]
    ]
];