<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms;

use Cms\Controller\CmsClassController;
use Cms\Controller\CmsSingleController;
use Cms\Controller\IndexController;

return [
    'Cms' => [
        'name' => '文章',
        'controllers' => [
            IndexController::class => [
                'name' => '文章管理',
                'action' => ['index', 'add', 'edit', 'delete'],
                'actionNames' => [
                    'index' => '文章列表',
                    'add'   => '添加文章',
                    'edit'  => '编辑文章',
                    'delete'=> '删除文章'
                ]
            ],

            CmsClassController::class => [
                'name' => '文章分类管理',
                'action' => ['index', 'add', 'edit', 'delete'],
                'actionNames' => [
                    'index' => '分类列表',
                    'add'   => '添加分类',
                    'edit'  => '编辑分类',
                    'delete'=> '删除分类'
                ]
            ],

            CmsSingleController::class => [
                'name' => '单页文章管理',
                'action' => ['index', 'add', 'edit', 'delete'],
                'actionNames' => [
                    'index' => '单页文章列表',
                    'add'   => '添加单页文章',
                    'edit'  => '编辑单页文章',
                    'delete'=> '删除单页文章'
                ]
            ]
        ]
    ]
];