<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 文章
 * Class Cms
 * @package Cms\Entity
 * @ORM\Entity(repositoryClass="Cms\Repository\CmsRepository")
 * @ORM\Table(name="dbshop_cms")
 */
class Cms extends BaseEntity
{
    /**
     * 文章自增id
     * @ORM\Id()
     * @ORM\Column(name="cms_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $cmsId;

    /**
     * 文章分类
     * @ORM\Column(name="cms_class_id", type="integer", length=11)
     */
    private $cmsClassId;

    /**
     * 文章作者
     * @ORM\Column(name="cms_writer", type="string", length=100)
     */
    private $cmsWriter;

    /**
     * 跳转URL
     * @ORM\Column(name="cms_url", type="string", length=300)
     */
    private $cmsUrl;

    /**
     * 文章标题
     * @ORM\Column(name="cms_title", type="string", length=200)
     */
    private $cmsTitle;

    /**
     * 文章内容
     * @ORM\Column(name="cms_body", type="string")
     */
    private $cmsBody;

    /**
     * 文章扩展标题
     * @ORM\Column(name="cms_extend_title", type="string", length=200)
     */
    private $cmsExtendTitle;

    /**
     * 文章关键字（SEO）
     * @ORM\Column(name="cms_keywords", type="string", length=200)
     */
    private $cmsKeywords;

    /**
     * 文章描述（SEO）
     * @ORM\Column(name="cms_description", type="string", length=500)
     */
    private $cmsDescription;

    /**
     * 文章状态，0 禁用 1 启用
     * @ORM\Column(name="cms_state", type="integer", length=1)
     */
    private $cmsState;

    /**
     * 文章排序，默认 255
     * @ORM\Column(name="cms_sort", type="integer", length=11)
     */
    private $cmsSort;

    /**
     * 文章添加时间
     * @ORM\Column(name="cms_add_time", type="integer", length=10)
     */
    private $cmsAddTime;

    /**
     * @return mixed
     */
    public function getCmsId()
    {
        return $this->cmsId;
    }

    /**
     * @param mixed $cmsId
     */
    public function setCmsId($cmsId): void
    {
        $this->cmsId = $cmsId;
    }

    /**
     * @return mixed
     */
    public function getCmsClassId()
    {
        return $this->cmsClassId;
    }

    /**
     * @param mixed $cmsClassId
     */
    public function setCmsClassId($cmsClassId): void
    {
        $this->cmsClassId = $cmsClassId;
    }

    /**
     * @return mixed
     */
    public function getCmsWriter()
    {
        return $this->cmsWriter;
    }

    /**
     * @param mixed $cmsWriter
     */
    public function setCmsWriter($cmsWriter): void
    {
        $this->cmsWriter = $cmsWriter;
    }

    /**
     * @return mixed
     */
    public function getCmsUrl()
    {
        return $this->cmsUrl;
    }

    /**
     * @param mixed $cmsUrl
     */
    public function setCmsUrl($cmsUrl): void
    {
        $this->cmsUrl = $cmsUrl;
    }

    /**
     * @return mixed
     */
    public function getCmsTitle()
    {
        return $this->cmsTitle;
    }

    /**
     * @param mixed $cmsTitle
     */
    public function setCmsTitle($cmsTitle): void
    {
        $this->cmsTitle = $cmsTitle;
    }

    /**
     * @return mixed
     */
    public function getCmsBody()
    {
        return $this->cmsBody;
    }

    /**
     * @param mixed $cmsBody
     */
    public function setCmsBody($cmsBody): void
    {
        $this->cmsBody = $cmsBody;
    }

    /**
     * @return mixed
     */
    public function getCmsExtendTitle()
    {
        return $this->cmsExtendTitle;
    }

    /**
     * @param mixed $cmsExtendTitle
     */
    public function setCmsExtendTitle($cmsExtendTitle): void
    {
        $this->cmsExtendTitle = $cmsExtendTitle;
    }

    /**
     * @return mixed
     */
    public function getCmsKeywords()
    {
        return $this->cmsKeywords;
    }

    /**
     * @param mixed $cmsKeywords
     */
    public function setCmsKeywords($cmsKeywords): void
    {
        $this->cmsKeywords = $cmsKeywords;
    }

    /**
     * @return mixed
     */
    public function getCmsDescription()
    {
        return $this->cmsDescription;
    }

    /**
     * @param mixed $cmsDescription
     */
    public function setCmsDescription($cmsDescription): void
    {
        $this->cmsDescription = $cmsDescription;
    }

    /**
     * @return mixed
     */
    public function getCmsState()
    {
        return $this->cmsState;
    }

    /**
     * @param mixed $cmsState
     */
    public function setCmsState($cmsState): void
    {
        $this->cmsState = $cmsState;
    }

    /**
     * @return mixed
     */
    public function getCmsSort()
    {
        return $this->cmsSort;
    }

    /**
     * @param mixed $cmsSort
     */
    public function setCmsSort($cmsSort): void
    {
        $this->cmsSort = $cmsSort;
    }

    /**
     * @return mixed
     */
    public function getCmsAddTime()
    {
        return $this->cmsAddTime;
    }

    /**
     * @param mixed $cmsAddTime
     */
    public function setCmsAddTime($cmsAddTime): void
    {
        $this->cmsAddTime = $cmsAddTime;
    }
}