<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 文章分类
 * Class CmsClass
 * @package Cms\Entity
 * @ORM\Entity(repositoryClass="Cms\Repository\CmsClassRepository")
 * @ORM\Table(name="dbshop_cms_class")
 */
class CmsClass extends BaseEntity
{
    /**
     * 文章分类自增id
     * @ORM\Id()
     * @ORM\Column(name="cms_class_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $cmsClassId;

    /**
     * 文章分类上级分类，0 为顶级分类（文章分类只有二级）
     * @ORM\Column(name="cms_class_top_id", type="integer", length=11)
     */
    private $cmsClassTopId;

    /**
     * 文章分类名称
     * @ORM\Column(name="cms_class_name", type="string", length=200)
     */
    private $cmsClassName;

    /**
     * 文章分类状态 0 禁用，1 启用
     * @ORM\Column(name="cms_class_state", type="integer", length=1)
     */
    private $cmsClassState;

    /**
     * 文章分类扩展名
     * @ORM\Column(name="cms_class_extend_name", type="string", length=200)
     */
    private $cmsClassExtendName;

    /**
     * 文章分类关键字（SEO）
     * @ORM\Column(name="cms_class_keywords", type="string", length=200)
     */
    private $cmsClassKeywords;

    /**
     * 文章分类描述（SEO）
     * @ORM\Column(name="cms_class_description", type="string", length=500)
     */
    private $cmsClassDescription;

    /**
     * 文章分类排序
     * @ORM\Column(name="cms_class_sort", type="integer", length=11)
     */
    private $cmsClassSort;

    /**
     * 首页新闻，只有在有新闻显示的模板首页，才会显示
     * @ORM\Column(name="index_news", type="integer", length=1)
     */
    private $indexNews = 0;

    /**
     * @return mixed
     */
    public function getCmsClassId()
    {
        return $this->cmsClassId;
    }

    /**
     * @param mixed $cmsClassId
     */
    public function setCmsClassId($cmsClassId): void
    {
        $this->cmsClassId = $cmsClassId;
    }

    /**
     * @return mixed
     */
    public function getCmsClassTopId()
    {
        return $this->cmsClassTopId;
    }

    /**
     * @param mixed $cmsClassTopId
     */
    public function setCmsClassTopId($cmsClassTopId): void
    {
        $this->cmsClassTopId = $cmsClassTopId;
    }

    /**
     * @return mixed
     */
    public function getCmsClassName()
    {
        return $this->cmsClassName;
    }

    /**
     * @param mixed $cmsClassName
     */
    public function setCmsClassName($cmsClassName): void
    {
        $this->cmsClassName = $cmsClassName;
    }

    /**
     * @return mixed
     */
    public function getCmsClassState()
    {
        return $this->cmsClassState;
    }

    /**
     * @param mixed $cmsClassState
     */
    public function setCmsClassState($cmsClassState): void
    {
        $this->cmsClassState = $cmsClassState;
    }

    /**
     * @return mixed
     */
    public function getCmsClassExtendName()
    {
        return $this->cmsClassExtendName;
    }

    /**
     * @param mixed $cmsClassExtendName
     */
    public function setCmsClassExtendName($cmsClassExtendName): void
    {
        $this->cmsClassExtendName = $cmsClassExtendName;
    }

    /**
     * @return mixed
     */
    public function getCmsClassKeywords()
    {
        return $this->cmsClassKeywords;
    }

    /**
     * @param mixed $cmsClassKeywords
     */
    public function setCmsClassKeywords($cmsClassKeywords): void
    {
        $this->cmsClassKeywords = $cmsClassKeywords;
    }

    /**
     * @return mixed
     */
    public function getCmsClassDescription()
    {
        return $this->cmsClassDescription;
    }

    /**
     * @param mixed $cmsClassDescription
     */
    public function setCmsClassDescription($cmsClassDescription): void
    {
        $this->cmsClassDescription = $cmsClassDescription;
    }

    /**
     * @return mixed
     */
    public function getCmsClassSort()
    {
        return $this->cmsClassSort;
    }

    /**
     * @param mixed $cmsClassSort
     */
    public function setCmsClassSort($cmsClassSort): void
    {
        $this->cmsClassSort = $cmsClassSort;
    }

    /**
     * @return mixed
     */
    public function getIndexNews()
    {
        return $this->indexNews;
    }

    /**
     * @param mixed $indexNews
     */
    public function setIndexNews($indexNews): void
    {
        $this->indexNews = $indexNews;
    }
}