<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 单页cms
 * Class SingleCms
 * @package Cms\Entity
 * @ORM\Entity(repositoryClass="Cms\Repository\SingleCmsRepository")
 * @ORM\Table(name="dbshop_single_cms")
 */
class SingleCms extends BaseEntity
{
    /**
     * 单页文章ID
     * @ORM\Id()
     * @ORM\Column(name="single_cms_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $singleCmsId;

    /**
     * 单页文章标题
     * @ORM\Column(name="single_cms_title", type="string", length=200)
     */
    private $singleCmsTitle;

    /**
     * 单页内容
     * @ORM\Column(name="single_cms_body", type="string")
     */
    private $singleCmsBody;

    /**
     * 扩展标题（SEO）
     * @ORM\Column(name="single_cms_extend_title", type="string", length=200)
     */
    private $singleCmsExtendTitle;

    /**
     * 关键字（SEO）
     * @ORM\Column(name="single_cms_keywords", type="string", length=200)
     */
    private $singleCmsKeywords;

    /**
     * 描述（SEO）
     * @ORM\Column(name="single_cms_description", type="string", length=500)
     */
    private $singleCmsDescription;

    /**
     * 排序
     * @ORM\Column(name="single_cms_sort", type="integer", length=11)
     */
    private $singleCmsSort;

    /**
     * 模板对应的标签code
     * @ORM\Column(name="single_tag", type="string", length=50)
     */
    private $singleTag;

    /**
     * 模板的code名称
     * @ORM\Column(name="template_code", type="string", length=50)
     */
    private $templateCode;

    /**
     * @return mixed
     */
    public function getSingleCmsId()
    {
        return $this->singleCmsId;
    }

    /**
     * @param mixed $singleCmsId
     */
    public function setSingleCmsId($singleCmsId): void
    {
        $this->singleCmsId = $singleCmsId;
    }

    /**
     * @return mixed
     */
    public function getSingleCmsTitle()
    {
        return $this->singleCmsTitle;
    }

    /**
     * @param mixed $singleCmsTitle
     */
    public function setSingleCmsTitle($singleCmsTitle): void
    {
        $this->singleCmsTitle = $singleCmsTitle;
    }

    /**
     * @return mixed
     */
    public function getSingleCmsBody()
    {
        return $this->singleCmsBody;
    }

    /**
     * @param mixed $singleCmsBody
     */
    public function setSingleCmsBody($singleCmsBody): void
    {
        $this->singleCmsBody = $singleCmsBody;
    }

    /**
     * @return mixed
     */
    public function getSingleCmsExtendTitle()
    {
        return $this->singleCmsExtendTitle;
    }

    /**
     * @param mixed $singleCmsExtendTitle
     */
    public function setSingleCmsExtendTitle($singleCmsExtendTitle): void
    {
        $this->singleCmsExtendTitle = $singleCmsExtendTitle;
    }

    /**
     * @return mixed
     */
    public function getSingleCmsKeywords()
    {
        return $this->singleCmsKeywords;
    }

    /**
     * @param mixed $singleCmsKeywords
     */
    public function setSingleCmsKeywords($singleCmsKeywords): void
    {
        $this->singleCmsKeywords = $singleCmsKeywords;
    }

    /**
     * @return mixed
     */
    public function getSingleCmsDescription()
    {
        return $this->singleCmsDescription;
    }

    /**
     * @param mixed $singleCmsDescription
     */
    public function setSingleCmsDescription($singleCmsDescription): void
    {
        $this->singleCmsDescription = $singleCmsDescription;
    }

    /**
     * @return mixed
     */
    public function getSingleCmsSort()
    {
        return $this->singleCmsSort;
    }

    /**
     * @param mixed $singleCmsSort
     */
    public function setSingleCmsSort($singleCmsSort): void
    {
        $this->singleCmsSort = $singleCmsSort;
    }

    /**
     * @return mixed
     */
    public function getSingleTag()
    {
        return $this->singleTag;
    }

    /**
     * @param mixed $singleTag
     */
    public function setSingleTag($singleTag): void
    {
        $this->singleTag = $singleTag;
    }

    /**
     * @return mixed
     */
    public function getTemplateCode()
    {
        return $this->templateCode;
    }

    /**
     * @param mixed $templateCode
     */
    public function setTemplateCode($templateCode): void
    {
        $this->templateCode = $templateCode;
    }
}