<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms\Form;

use Cms\Validator\CmsClassValidator;
use Laminas\Form\Form;

class CmsClassForm extends Form
{
    private $entityManager;
    private $cmsClass;

    public function __construct($entityManager = null, $cmsClass = null, $name = 'cms-class-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->entityManager= $entityManager;
        $this->cmsClass     = $cmsClass;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'select',
            'name'  => 'cmsClassTopId',
            'attributes'    => [
                'id'            => 'cmsClassTopId',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'cmsClassName',
            'attributes'    => [
                'id'            => 'cmsClassName',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'cmsClassState',
            'attributes'    => [
                'id'            => 'cmsClassState',
                'value'         => 1
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'cmsClassExtendName',
            'attributes'    => [
                'id'            => 'cmsClassExtendName',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'cmsClassKeywords',
            'attributes'    => [
                'id'            => 'cmsClassKeywords',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'cmsClassDescription',
            'attributes'    => [
                'id'            => 'cmsClassDescription',
                'class'         => 'form-control',
                'rows'          => 4
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'cmsClassSort',
            'attributes'    => [
                'id'        => 'cmsClassSort',
                'class'     => 'form-control',
                'value'     => 255,
                'min'       => 1
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'indexNews',
            'attributes'    => [
                'id'            => 'indexNews'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'cmsClassTopId',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => CmsClassValidator::class,
                    'options'   => [
                        'entityManager' => $this->entityManager,
                        'cmsClass'      => $this->cmsClass
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'cmsClassName',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 200
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'cmsClassExtendName',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 200
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'cmsClassState',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);
        
        $inputFilter->add([
            'name'      => 'cmsClassKeywords',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 200
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'cmsClassDescription',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 500
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'cmsClassSort',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'indexNews',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);
    }
}