<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms\Form;

use Laminas\Form\Form;

class SingleCmsForm extends Form
{
    public function __construct($name = 'single-cms-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'singleCmsTitle',
            'attributes'    => [
                'id'            => 'singleCmsTitle',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'singleCmsBody',
            'attributes'    => [
                'id'            => 'singleCmsBody',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'singleCmsExtendTitle',
            'attributes'    => [
                'id'            => 'singleCmsExtendTitle',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'singleCmsKeywords',
            'attributes'    => [
                'id'            => 'singleCmsKeywords',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'singleCmsDescription',
            'attributes'    => [
                'id'            => 'singleCmsDescription',
                'class'         => 'form-control',
                'rows'          => 4
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'singleCmsSort',
            'attributes'    => [
                'id'        => 'singleCmsSort',
                'class'     => 'form-control',
                'value'     => 255,
                'min'       => 1
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'singleTag',
            'attributes'    => [
                'id'            => 'singleTag',
                'class'         => 'form-control'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'singleCmsTitle',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 200
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'singleCmsBody',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'singleCmsExtendTitle',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 200
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'singleCmsKeywords',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 200
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'singleCmsDescription',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 500
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'singleCmsSort',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'singleCmsDescription',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 500
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'singleTag',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
    }
}