<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms\Plugin;

use Admin\Data\Common;
use Cms\Entity\CmsClass;
use Doctrine\ORM\EntityManager;
use Laminas\Mvc\Controller\Plugin\AbstractPlugin;
use Laminas\Mvc\I18n\Translator;

class CmsPlugin extends AbstractPlugin
{
    private $entityManager;
    private $translator;

    public function __construct(
        EntityManager   $entityManager,
        Translator      $translator
    )
    {
        $this->entityManager    = $entityManager;
        $this->translator       = $translator;
    }

    /**
     * 获取文章顶级分类
     * @param string $topName
     * @return array
     */
    public function cmsClassTopListOptions($topName = '')
    {
        $cmsClassList   = ['0' => empty($topName) ? $this->translator->translate('===选择分类===') : $topName];
        $cmsClass       = $this->entityManager->getRepository(CmsClass::class)->findBy(['cmsClassTopId' => 0], ['cmsClassSort' => 'ASC']);
        if($cmsClass) foreach ($cmsClass as $value) {
            $cmsClassList[$value->getCmsClassId()] = $value->getCmsClassName();
        }

        return $cmsClassList;
    }

    /**
     * 获取文章分类
     * @param string $topName
     * @return array
     */
    public function cmsClassListOptions($topName = '')
    {
        $cmsClassList   = ['' => empty($topName) ? $this->translator->translate('===选择分类===') : $topName];

        $cmsClass = $this->entityManager->getRepository(CmsClass::class)->findBy([], ['cmsClassTopId' => 'ASC', 'cmsClassSort' => 'ASC']);
        if($cmsClass) {
            $classList= Common::classOptions($cmsClass, 0, 'getCmsClassTopId', 'getCmsClassId');
            $nbspStr = html_entity_decode('&nbsp;', ENT_COMPAT, 'UTF-8');
            foreach ($classList as $value) {
                if($value->getCmsClassTopId() > 0) $cmsClassList[$value->getCmsClassId()] = str_repeat($nbspStr, 3) . '|----' . $value->getCmsClassName();
                else $cmsClassList[$value->getCmsClassId()] = $value->getCmsClassName();
            }
        }

        return $cmsClassList;
    }
}