<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms\Repository;

use Cms\Entity\Cms;
use Cms\Entity\CmsClass;
use Doctrine\ORM\EntityRepository;

class CmsClassRepository extends EntityRepository
{
    /**
     * 获取分类文章数
     * @param array $search
     * @return int|mixed|string
     */
    public function findClassCmsNum(array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('c.cmsClassId')
            ->addSelect('(SELECT COUNT(m.cmsId) FROM '.Cms::class.' AS m WHERE m.cmsClassId=c.cmsClassId) AS cmsNum')
            ->from(CmsClass::class, 'c');

        return $query->getQuery()->getResult();
    }
}