<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class CmsSearch
{
    public static function querySearchData($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['start_id']) && $search['start_id'] > 0)               $queryBuilder->andWhere($queryBuilder->expr()->gte('c.cmsId', $search['start_id']));
        if(isset($search['end_id']) && $search['end_id'] > 0)                   $queryBuilder->andWhere($queryBuilder->expr()->lte('c.cmsId', $search['end_id']));
        if(isset($search['cms_title']) && !empty($search['cms_title']))         $queryBuilder->andWhere($queryBuilder->expr()->like('c.cmsTitle', "'%".$search['cms_title']."%'"));
        if(isset($search['cms_class_id']) && !empty($search['cms_class_id']))   $queryBuilder->andWhere($queryBuilder->expr()->eq('c.cmsClassId', ':cmsClassId'))->setParameter('cmsClassId', intval($search['cms_class_id']));
        if(isset($search['cms_state']) && !empty($search['cms_state']))         $queryBuilder->andWhere($queryBuilder->expr()->eq('c.cmsState', ':cmsState'))->setParameter('cmsState', $search['cms_state']);
        if(isset($search['start_time']) && !empty($search['start_time']))       $queryBuilder->andWhere($queryBuilder->expr()->gte('c.cmsAddTime', ':startTime'))->setParameter('startTime', strtotime($search['start_time'].' 00:00:00'));
        if(isset($search['end_time']) && !empty($search['end_time']))           $queryBuilder->andWhere($queryBuilder->expr()->lte('c.cmsAddTime', ':endTime'))->setParameter('endTime', strtotime($search['end_time'].' 23:59:59'));

        return $queryBuilder;
    }
}