<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms\Service;

use Cms\Entity\CmsClass;
use Doctrine\ORM\EntityManager;

class CmsClassManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加文章分类
     * @param array $data
     * @return CmsClass
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addCmsClass(array $data)
    {
        $cmsClass = new CmsClass();
        $cmsClass->valuesSet($data);

        $this->entityManager->persist($cmsClass);
        $this->entityManager->flush();

        return $cmsClass;
    }

    /**
     * 编辑文章分类
     * @param array $data
     * @param CmsClass $cmsClass
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editCmsClass(array $data, CmsClass $cmsClass)
    {
        $cmsClass->valuesSet($data);
        $this->entityManager->flush();

        return true;
    }

    /**
     * 删除文章分类
     * @param CmsClass $cmsClass
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteCmsClass(CmsClass $cmsClass)
    {
        $this->entityManager->remove($cmsClass);
        $this->entityManager->flush();

        return true;
    }
}