<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms\Service;

use Admin\Data\Common;
use Admin\Data\Config;
use Cms\Entity\Cms;
use Doctrine\ORM\EntityManager;

class CmsManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加文章
     * @param array $data
     * @return Cms
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addCms(array $data)
    {
        $cms = new Cms();
        $data['cmsAddTime'] = !empty($data['cmsAddTime']) ? strtotime($data['cmsAddTime']) : '';
        $cms->valuesSet($data);

        $this->entityManager->persist($cms);
        $this->entityManager->flush();

        return $cms;
    }

    /**
     * 编辑文章
     * @param array $data
     * @param Cms $cms
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editCms(array $data, Cms $cms)
    {
        $data['cmsAddTime'] = !empty($data['cmsAddTime']) ? strtotime($data['cmsAddTime']) : '';
        $cms->valuesSet($data);
        $this->entityManager->flush();

        return true;
    }

    /**
     * 删除文章
     * @param Cms $cms
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteCms(Cms $cms)
    {
        $imageList = Common::bodyImageArray($cms->getCmsBody());

        $this->entityManager->remove($cms);
        $this->entityManager->flush();

        if ($imageList) foreach ($imageList as $imageValue) {
            if (stripos($imageValue, 'http') !== false) continue;
            @unlink(Config::CMS_IMAGE_PATH . basename($imageValue));
        }

        return true;
    }
}