<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms\Validator;

use Laminas\Validator\AbstractValidator;

class CmsClassValidator extends AbstractValidator
{
    const NOT_SCALAR    = 'notScalar';
    const NOT_SELF      = 'notSelf';

    protected $options = [
        'entityManager',
        'cmsClass'
    ];

    protected $messageTemplates = [
        self::NOT_SCALAR => "这不是一个标准输入值",
        self::NOT_SELF   => "不能为分类本身"
    ];

    public function __construct($options = [])
    {
        if(is_array($options)) {
            if(isset($options['entityManager']))    $this->options['entityManager'] = $options['entityManager'];
            if(isset($options['cmsClass']))         $this->options['cmsClass']      = $options['cmsClass'];
        }

        parent::__construct($options);
    }

    public function isValid($value)
    {
        if(!is_scalar($value)) {
            $this->error(self::NOT_SCALAR);
            return false;
        }

        if($this->options['cmsClass'] == null || $value == 0) return true;

        if($this->options['cmsClass']->getCmsClassId() == $value) {
            $this->error(self::NOT_SELF);
            return false;
        }

        return true;
    }
}