<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Cms\View;

use Admin\Data\Common;
use Laminas\Mvc\I18n\Translator;
use Laminas\View\Helper\AbstractHelper;

class CmsHelper extends AbstractHelper
{
    private $translator;

    public function __construct(
        Translator  $translator
    )
    {
        $this->translator   = $translator;
    }

    /**
     * 文章分类状态
     * @param $state
     * @return mixed
     */
    public function cmsClassState($state)
    {
        $cmsClassState = Common::state($this->translator);

        return $cmsClassState[$state];
    }

    /**
     * 文章状态
     * @param $state
     * @return mixed
     */
    public function cmsState($state)
    {
        $cmsState = Common::state($this->translator);

        return $cmsState[$state];
    }
}