<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Extend;

use Admin\Data\Config;
use Extend\Controller\Factory\IndexControllerFactory;
use Extend\Controller\Factory\NavigationControllerFactory;
use Extend\Controller\Factory\OnlineServiceControllerFactory;
use Extend\Controller\Factory\SystemNoticeControllerFactory;
use Extend\Controller\IndexController;
use Doctrine\ORM\Mapping\Driver\AnnotationDriver;
use Extend\Controller\NavigationController;
use Extend\Controller\OnlineServiceController;
use Extend\Controller\SystemNoticeController;
use Extend\Event\ExtendListener;
use Extend\Event\Factory\ExtendListenerFactory;
use Extend\Service\Factory\NavigationManagerFactory;
use Extend\Service\Factory\SystemNoticeManagerFactory;
use Extend\Service\NavigationManager;
use Extend\Service\SystemNoticeManager;
use Extend\View\ExtendHelper;
use Extend\View\Factory\ExtendHelperFactory;
use Laminas\Router\Http\Segment;

return [
    'router' => [
        'routes' => [
            'extend' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/extend[/:action]',
                    'defaults' => [
                        'controller' => IndexController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //导航
            'navigation' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/navigation[/:action[/:id]]',
                    'defaults' => [
                        'controller' => NavigationController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //在线客服
            'online-service' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/online-service[/:action[/:id]]',
                    'defaults' => [
                        'controller' => OnlineServiceController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //系统通知
            'system-notice' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/system-notice[/:action[/:id]]',
                    'defaults' => [
                        'controller' => SystemNoticeController::class,
                        'action'    => 'index'
                    ]
                ]
            ],
        ]
    ],

    'controllers' => [
        'factories' => [
            IndexController::class      => IndexControllerFactory::class,
            NavigationController::class => NavigationControllerFactory::class,
            OnlineServiceController::class  => OnlineServiceControllerFactory::class,
            SystemNoticeController::class   => SystemNoticeControllerFactory::class
        ]
    ],

    'service_manager' => [
        'factories' => [
            NavigationManager::class    => NavigationManagerFactory::class,
            SystemNoticeManager::class  => SystemNoticeManagerFactory::class,

            ExtendListener::class       => ExtendListenerFactory::class
        ]
    ],

    'listeners' => [
        ExtendListener::class
    ],

    'permission_filter' => include __DIR__ . '/permission.php',

    'controller_plugins' => [
        'factories' => [

        ],
        'aliases'   => [

        ]
    ],

    'view_helpers' => [
        'factories' => [
            ExtendHelper::class => ExtendHelperFactory::class
        ],
        'aliases' => [
            'extendHelper' => ExtendHelper::class
        ],
    ],

    'translator' => [
        'translation_file_patterns' => [
            [
                'type' => 'gettext',
                'base_dir' => __DIR__ . '/../data/language',
                'pattern' => '%s.mo'
            ]
        ]
    ],

    'view_manager' => [
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ]
    ],

    'doctrine' => [
        'driver' => [
            __NAMESPACE__ . '_driver' => [
                'class' => AnnotationDriver::class,
                'cache' => 'array',
                'paths' => [__DIR__ . '/../src/Entity']
            ],
            'orm_default' => [
                'drivers' => [
                    __NAMESPACE__ . '\Entity' => __NAMESPACE__ . '_driver'
                ]
            ]
        ]
    ]
];