<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Extend;

use Extend\Controller\IndexController;
use Extend\Controller\NavigationController;

return [
    'Extend' => [
        'name' => '扩展',
        'controllers' => [
            IndexController::class => [
                'name' => '扩展插件',
                'action' => ['index', 'pluginList'],
                'actionNames' => [
                    'index'     => '已安装插件列表',
                    'pluginList'=> '安装扩展插件列表'
                ]
            ],

            NavigationController::class => [
                'name' => '导航设置',
                'action' => ['index', 'add', 'edit', 'delete'],
                'actionNames' => [
                    'index' => '导航列表',
                    'add'   => '添加导航',
                    'edit'  => '编辑导航',
                    'delete'=> '删除导航'
                ]
            ]
        ]
    ]
];