<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Extend\Controller\Factory;

use Admin\Data\Config;
use Extend\Controller\NavigationController;
use Extend\Service\NavigationManager;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;

class NavigationControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $navigationManager  = $container->get(NavigationManager::class);

        return new NavigationController($translator, $entityManager, $navigationManager);
    }
}