<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Extend\Controller;

use Admin\Controller\AdminActionController;
use Admin\Data\Common;
use Doctrine\ORM\EntityManager;
use Extend\Form\OnlineServiceForm;
use Laminas\Config\Factory;
use Laminas\Mvc\I18n\Translator;

class OnlineServiceController extends AdminActionController
{
    private $translator;
    private $entityManager;
    private $onlineType;
    private $displayRange;
    private $client;

    public function __construct(
        Translator $translator,
        EntityManager $entityManager
    )
    {
        $this->translator   = $translator;
        $this->entityManager= $entityManager;

        $this->client       = ['pc' => $this->translator->translate('PC端'), 'mobile' => $this->translator->translate('手机端')];
        $this->onlineType   = ['qq' => $this->translator->translate('腾讯QQ'), 'wangwang' => $this->translator->translate('阿里旺旺'), 'skype' => 'Skype', 'phone' => $this->translator->translate('电话')];
        $this->displayRange = [
            'IndexController-index' => $this->translator->translate('首页'),
            'ClassController-goodsList' => $this->translator->translate('商品列表页'),
            'GoodsController-index' => $this->translator->translate('商品内容页')
        ];
    }

    /**
     * 在线客服
     * @return OnlineServiceForm[]|\Laminas\Http\Response|\Laminas\View\Model\ViewModel
     */
    public function indexAction()
    {
        $form = new OnlineServiceForm();
        $form->get('displayRange')->setValueOptions($this->displayRange);
        $form->get('client')->setValueOptions($this->client);
        $form->get('onlineType1')->setValueOptions($this->onlineType);
        $form->get('onlineType2')->setValueOptions($this->onlineType);
        $form->get('onlineType3')->setValueOptions($this->onlineType);
        $form->get('onlineType4')->setValueOptions($this->onlineType);
        $form->get('onlineType5')->setValueOptions($this->onlineType);
        $form->get('onlineDisplayRange1')->setValueOptions($this->displayRange);
        $form->get('onlineDisplayRange2')->setValueOptions($this->displayRange);
        $form->get('onlineDisplayRange3')->setValueOptions($this->displayRange);
        $form->get('onlineDisplayRange4')->setValueOptions($this->displayRange);
        $form->get('onlineDisplayRange5')->setValueOptions($this->displayRange);
        $form->get('onlineClient')->setValueOptions($this->client);

        if($this->getRequest()->isPost()) {
            $data = $this->params()->fromPost();
            $form->setData($data);
            if ($form->isValid()) {
                $data = $form->getData();

                $onlineBody = Factory::fromFile('data/moduleData/Extend/online/onlineBody.php');
                $onlineService = [
                    'longService'   => ['id' => $data['longServiceId'], 'range' => $data['displayRange'], 'client' => $data['client']],
                    'onlineService' => [
                        ['type' => $data['onlineType1'], 'title' => $data['onlineTitle1'], 'account' => $data['onlineAccount1'], 'range' => $data['onlineDisplayRange1']],
                        ['type' => $data['onlineType2'], 'title' => $data['onlineTitle2'], 'account' => $data['onlineAccount2'], 'range' => $data['onlineDisplayRange2']],
                        ['type' => $data['onlineType3'], 'title' => $data['onlineTitle3'], 'account' => $data['onlineAccount3'], 'range' => $data['onlineDisplayRange3']],
                        ['type' => $data['onlineType4'], 'title' => $data['onlineTitle4'], 'account' => $data['onlineAccount4'], 'range' => $data['onlineDisplayRange4']],
                        ['type' => $data['onlineType5'], 'title' => $data['onlineTitle5'], 'account' => $data['onlineAccount5'], 'range' => $data['onlineDisplayRange5']]
                    ],
                    'onlineServiceClient' => $data['onlineClient'],
                    'onlineBody'    => [
                        'long'  => ['range' => $data['displayRange'], 'content' => empty($data['longServiceId']) ? '' : str_replace('{account}', $data['longServiceId'], $onlineBody['long'])],
                        'online'=> [
                            ['range' => $data['onlineDisplayRange1'], 'content' => empty($data['onlineAccount1']) ? '' : str_replace(['{account}', '{title}'], [$data['onlineAccount1'], $data['onlineTitle1']], $onlineBody[$data['onlineType1']])],
                            ['range' => $data['onlineDisplayRange2'], 'content' => empty($data['onlineAccount2']) ? '' : str_replace(['{account}', '{title}'], [$data['onlineAccount2'], $data['onlineTitle2']], $onlineBody[$data['onlineType2']])],
                            ['range' => $data['onlineDisplayRange3'], 'content' => empty($data['onlineAccount3']) ? '' : str_replace(['{account}', '{title}'], [$data['onlineAccount3'], $data['onlineTitle3']], $onlineBody[$data['onlineType3']])],
                            ['range' => $data['onlineDisplayRange4'], 'content' => empty($data['onlineAccount4']) ? '' : str_replace(['{account}', '{title}'], [$data['onlineAccount4'], $data['onlineTitle4']], $onlineBody[$data['onlineType4']])],
                            ['range' => $data['onlineDisplayRange5'], 'content' => empty($data['onlineAccount5']) ? '' : str_replace(['{account}', '{title}'], [$data['onlineAccount5'], $data['onlineTitle5']], $onlineBody[$data['onlineType5']])]
                        ]
                    ]
                ];
                Common::writeConfigFile('onlineService', $onlineService);

                $this->adminCommon()->addOperLog($this->translator->translate('在线客服设置成功!'), $this->translator->translate('在线客服'));

                return $this->redirect()->toRoute('online-service');
            }
        }

        $onlineServiceData = Common::readConfigFile('onlineService');
        if (!empty($onlineServiceData)) {
            $form->setData([
                'longServiceId' => $onlineServiceData['longService']['id'],
                'displayRange'  => $onlineServiceData['longService']['range'],
                'client'        => $onlineServiceData['longService']['client'],

                'onlineClient'   => $onlineServiceData['onlineServiceClient'],
                'onlineType1'   => $onlineServiceData['onlineService'][0]['type'],
                'onlineTitle1'  => $onlineServiceData['onlineService'][0]['title'],
                'onlineAccount1'=> $onlineServiceData['onlineService'][0]['account'],
                'onlineDisplayRange1' => $onlineServiceData['onlineService'][0]['range'],
                'onlineType2'   => $onlineServiceData['onlineService'][1]['type'],
                'onlineTitle2'  => $onlineServiceData['onlineService'][1]['title'],
                'onlineAccount2'=> $onlineServiceData['onlineService'][1]['account'],
                'onlineDisplayRange2' => $onlineServiceData['onlineService'][1]['range'],
                'onlineType3'   => $onlineServiceData['onlineService'][2]['type'],
                'onlineTitle3'  => $onlineServiceData['onlineService'][2]['title'],
                'onlineAccount3'=> $onlineServiceData['onlineService'][2]['account'],
                'onlineDisplayRange3' => $onlineServiceData['onlineService'][2]['range'],
                'onlineType4'   => $onlineServiceData['onlineService'][3]['type'],
                'onlineTitle4'  => $onlineServiceData['onlineService'][3]['title'],
                'onlineAccount4'=> $onlineServiceData['onlineService'][3]['account'],
                'onlineDisplayRange4' => $onlineServiceData['onlineService'][3]['range'],
                'onlineType5'   => $onlineServiceData['onlineService'][4]['type'],
                'onlineTitle5'  => $onlineServiceData['onlineService'][4]['title'],
                'onlineAccount5'=> $onlineServiceData['onlineService'][4]['account'],
                'onlineDisplayRange5' => $onlineServiceData['onlineService'][4]['range'],
            ]);
        }

        return ['form' => $form];
    }
}