<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Extend\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 前台导航表
 * Class Navigation
 * @package Extend\Entity
 * @ORM\Entity(repositoryClass="Extend\Repository\NavigationRepository")
 * @ORM\Table(name="dbshop_navigation")
 */
class Navigation extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="navigation_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $navigationId;

    /**
     * 导航标题
     * @ORM\Column(name="navigation_title", type="string", length=200)
     */
    private $navigationTitle;

    /**
     * 导航Url
     * @ORM\Column(name="navigation_url", type="string", length=500)
     */
    private $navigationUrl;

    /**
     * 导航位置，1 顶部、2 中部、3 底部
     * @ORM\Column(name="navigation_place", type="integer", length=1)
     */
    private $navigationPlace;

    /**
     * 商品分类id
     * @ORM\Column(name="goods_class_id", type="integer", length=11)
     */
    private $goodsClassId = 0;

    /**
     * 是否新窗口打开，0 否，1 是
     * @ORM\Column(name="new_window", type="integer", length=1)
     */
    private $newWindow = 0;

    /**
     * 排序
     * @ORM\Column(name="navigation_sort", type="integer", length=11)
     */
    private $navigationSort = 255;

    /**
     * @return mixed
     */
    public function getNavigationId()
    {
        return $this->navigationId;
    }

    /**
     * @param mixed $navigationId
     */
    public function setNavigationId($navigationId): void
    {
        $this->navigationId = $navigationId;
    }

    /**
     * @return mixed
     */
    public function getNavigationTitle()
    {
        return $this->navigationTitle;
    }

    /**
     * @param mixed $navigationTitle
     */
    public function setNavigationTitle($navigationTitle): void
    {
        $this->navigationTitle = $navigationTitle;
    }

    /**
     * @return mixed
     */
    public function getNavigationUrl()
    {
        return $this->navigationUrl;
    }

    /**
     * @param mixed $navigationUrl
     */
    public function setNavigationUrl($navigationUrl): void
    {
        $this->navigationUrl = $navigationUrl;
    }

    /**
     * @return mixed
     */
    public function getNavigationPlace()
    {
        return $this->navigationPlace;
    }

    /**
     * @param mixed $navigationPlace
     */
    public function setNavigationPlace($navigationPlace): void
    {
        $this->navigationPlace = $navigationPlace;
    }

    /**
     * @return mixed
     */
    public function getGoodsClassId()
    {
        return $this->goodsClassId;
    }

    /**
     * @param mixed $goodsClassId
     */
    public function setGoodsClassId($goodsClassId): void
    {
        $this->goodsClassId = $goodsClassId;
    }

    /**
     * @return mixed
     */
    public function getNewWindow()
    {
        return $this->newWindow;
    }

    /**
     * @param mixed $newWindow
     */
    public function setNewWindow($newWindow): void
    {
        $this->newWindow = $newWindow;
    }

    /**
     * @return mixed
     */
    public function getNavigationSort()
    {
        return $this->navigationSort;
    }

    /**
     * @param mixed $navigationSort
     */
    public function setNavigationSort($navigationSort): void
    {
        $this->navigationSort = $navigationSort;
    }
}