<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Extend\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 后台系统通知
 * Class SystemNotice
 * @package Extend\Entity
 * @ORM\Entity(repositoryClass="Extend\Repository\SystemNoticeRepository")
 * @ORM\Table(name="dbshop_system_notice")
 */
class SystemNotice extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="notice_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $noticeId;

    /**
     * 消息标题
     * @ORM\Column(name="notice_title", type="string", length=100)
     */
    private $noticeTitle;

    /**
     * 消息内容
     * @ORM\Column(name="notice_body", type="string", length=3000)
     */
    private $noticeBody;

    /**
     * 消息状态，0 未读 1 已读
     * @ORM\Column(name="notice_read_state", type="integer", length=1)
     */
    private $noticeReadState = 0;

    /**
     * 消息时间
     * @ORM\Column(name="notice_time", type="integer", length=10)
     */
    private $noticeTime;

    /**
     * 消息类型，如 order 订单相关 goods 商品相关
     * @ORM\Column(name="notice_type", type="string", length=20)
     */
    private $noticeType;

    /**
     * 消息分类，1 信息，2 通知，3 任务
     * @ORM\Column(name="notice_class", type="integer", length=1)
     */
    private $noticeClass;

    /**
     * @return mixed
     */
    public function getNoticeId()
    {
        return $this->noticeId;
    }

    /**
     * @param mixed $noticeId
     */
    public function setNoticeId($noticeId): void
    {
        $this->noticeId = $noticeId;
    }

    /**
     * @return mixed
     */
    public function getNoticeTitle()
    {
        return $this->noticeTitle;
    }

    /**
     * @param mixed $noticeTitle
     */
    public function setNoticeTitle($noticeTitle): void
    {
        $this->noticeTitle = $noticeTitle;
    }

    /**
     * @return mixed
     */
    public function getNoticeBody()
    {
        return $this->noticeBody;
    }

    /**
     * @param mixed $noticeBody
     */
    public function setNoticeBody($noticeBody): void
    {
        $this->noticeBody = $noticeBody;
    }

    /**
     * @return mixed
     */
    public function getNoticeReadState()
    {
        return $this->noticeReadState;
    }

    /**
     * @param mixed $noticeReadState
     */
    public function setNoticeReadState($noticeReadState): void
    {
        $this->noticeReadState = $noticeReadState;
    }

    /**
     * @return mixed
     */
    public function getNoticeTime()
    {
        return $this->noticeTime;
    }

    /**
     * @param mixed $noticeTime
     */
    public function setNoticeTime($noticeTime): void
    {
        $this->noticeTime = $noticeTime;
    }

    /**
     * @return mixed
     */
    public function getNoticeType()
    {
        return $this->noticeType;
    }

    /**
     * @param mixed $noticeType
     */
    public function setNoticeType($noticeType): void
    {
        $this->noticeType = $noticeType;
    }

    /**
     * @return mixed
     */
    public function getNoticeClass()
    {
        return $this->noticeClass;
    }

    /**
     * @param mixed $noticeClass
     */
    public function setNoticeClass($noticeClass): void
    {
        $this->noticeClass = $noticeClass;
    }
}