<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Extend\Event;

use Doctrine\ORM\EntityManager;
use Extend\Service\SystemNoticeManager;
use Laminas\EventManager\Event;
use Laminas\EventManager\EventManagerInterface;
use Laminas\EventManager\ListenerAggregateInterface;
use Laminas\I18n\Translator\Translator;

class ExtendListener implements ListenerAggregateInterface
{
    protected $listeners = [];

    private $entityManager;
    private $systemNoticeManager;

    private $translator;

    public function __construct(
        EntityManager   $entityManager,
        SystemNoticeManager $systemNoticeManager
    )
    {
        $this->entityManager = $entityManager;
        $this->systemNoticeManager = $systemNoticeManager;

        $this->translator   = new Translator();
    }

    public function attach(EventManagerInterface $events, $priority = 1)
    {
        $shareEvents = $events->getSharedManager();

        //前台商品咨询
        /*$this->listeners[] = $shareEvents->attach(
            'Shop\Controller\GoodsController', 'shop.goodsInfo.goods.addConsult', [$this, 'onAddGoodsConsultSystemNotice']
        );*/

        //前台商品评价
        /*$this->listeners[] = $shareEvents->attach(
            'Shop\Controller\HomeOrderController', 'shop.order.evaluation.post', [$this, 'onAddOrderGoodsEvaluationSystemNotice']
        );*/
    }

    public function detach(EventManagerInterface $events)
    {
        foreach ($this->listeners as $index => $listener) {
            $events->detach($listener);
            unset($this->listeners[$index]);
        }
    }

    /**
     * 商品咨询消息
     * @param Event $event
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function onAddGoodsConsultSystemNotice(Event $event)
    {
        $goodsInfo = $event->getParam('goodsInfo');

        $this->systemNoticeManager->addSystemNotice([
            'noticeTitle'   => $this->translator->translate('有新的商品咨询'),
            'noticeBody'    => $this->translator->translate('商品') . ' ' . $goodsInfo->getGoodsName(),
            'noticeTime'    => time(),
            'noticeType'    => 'goods',
            'noticeClass'   => 3    //任务
        ]);
    }

    /**
     * 商品评价消息
     * @param Event $event
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function onAddOrderGoodsEvaluationSystemNotice(Event $event)
    {
        $orderGoods = $event->getParam('orderGoodsInfo');

        $this->systemNoticeManager->addSystemNotice([
            'noticeTitle'   => $this->translator->translate('有新的商品评价'),
            'noticeBody'    => $this->translator->translate('商品') . ' ' . $orderGoods->getGoodsName(),
            'noticeTime'    => time(),
            'noticeType'    => 'order',
            'noticeClass'   => 2    //通知
        ]);
    }
}