<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Extend\Form;

use Laminas\Form\Form;

class OnlineServiceForm extends Form
{
    public function __construct($name = 'online-service-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'longServiceId',
            'attributes'    => [
                'id'            => 'longServiceId',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'displayRange',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'client',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'onlineType1',
            'attributes'    => [
                'id'            => 'onlineType1',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'onlineTitle1',
            'attributes'    => [
                'id'            => 'onlineTitle1',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'onlineAccount1',
            'attributes'    => [
                'id'            => 'onlineAccount1',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'onlineDisplayRange1',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'onlineClient',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'onlineType2',
            'attributes'    => [
                'id'            => 'onlineType2',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'onlineTitle2',
            'attributes'    => [
                'id'            => 'onlineTitle2',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'onlineAccount2',
            'attributes'    => [
                'id'            => 'onlineAccount2',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'onlineDisplayRange2',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'onlineType3',
            'attributes'    => [
                'id'            => 'onlineType3',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'onlineTitle3',
            'attributes'    => [
                'id'            => 'onlineTitle3',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'onlineAccount3',
            'attributes'    => [
                'id'            => 'onlineAccount3',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'onlineDisplayRange3',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'onlineType4',
            'attributes'    => [
                'id'            => 'onlineType4',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'onlineTitle4',
            'attributes'    => [
                'id'            => 'onlineTitle4',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'onlineAccount4',
            'attributes'    => [
                'id'            => 'onlineAccount4',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'onlineDisplayRange4',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'onlineType5',
            'attributes'    => [
                'id'            => 'onlineType5',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'onlineTitle5',
            'attributes'    => [
                'id'            => 'onlineTitle5',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'onlineAccount5',
            'attributes'    => [
                'id'            => 'onlineAccount5',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'onlineDisplayRange5',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'longServiceId',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'displayRange',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'client',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'onlineType1',
            'required'  => false
        ]);
        $inputFilter->add([
            'name'      => 'onlineTitle1',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
        $inputFilter->add([
            'name'      => 'onlineAccount1',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
        $inputFilter->add([
            'name'      => 'onlineDisplayRange1',
            'required'  => false
        ]);
        $inputFilter->add([
            'name'      => 'onlineClient',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'onlineType2',
            'required'  => false
        ]);
        $inputFilter->add([
            'name'      => 'onlineTitle2',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
        $inputFilter->add([
            'name'      => 'onlineAccount2',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
        $inputFilter->add([
            'name'      => 'onlineDisplayRange2',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'onlineType3',
            'required'  => false
        ]);
        $inputFilter->add([
            'name'      => 'onlineTitle3',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
        $inputFilter->add([
            'name'      => 'onlineAccount3',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
        $inputFilter->add([
            'name'      => 'onlineDisplayRange3',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'onlineType4',
            'required'  => false
        ]);
        $inputFilter->add([
            'name'      => 'onlineTitle4',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
        $inputFilter->add([
            'name'      => 'onlineAccount4',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
        $inputFilter->add([
            'name'      => 'onlineDisplayRange4',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'onlineType5',
            'required'  => false
        ]);
        $inputFilter->add([
            'name'      => 'onlineTitle5',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
        $inputFilter->add([
            'name'      => 'onlineAccount5',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
        $inputFilter->add([
            'name'      => 'onlineDisplayRange5',
            'required'  => false
        ]);

    }
}