<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Extend\Service;

use Doctrine\ORM\EntityManager;
use Extend\Entity\Navigation;

class NavigationManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加导航
     * @param array $data
     * @return Navigation
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addNavigation(array $data)
    {
        $navigation = new Navigation();
        $navigation->valuesSet($data);

        $this->entityManager->persist($navigation);
        $this->entityManager->flush();

        return $navigation;
    }

    /**
     * 编辑导航
     * @param array $data
     * @param Navigation $navigation
     * @return Navigation
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editNavigation(array $data, Navigation $navigation)
    {
        $navigation->valuesSet($data);
        $this->entityManager->flush();

        return $navigation;
    }

    /**
     * 删除导航
     * @param Navigation $navigation
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteNavigation(Navigation $navigation)
    {
        $this->entityManager->remove($navigation);
        $this->entityManager->flush();

        return true;
    }
}