<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods;

use Admin\Data\Config;
use Goods\Controller\Factory\GoodsAttributeControllerFactory;
use Goods\Controller\Factory\GoodsAttributeGroupControllerFactory;
use Goods\Controller\Factory\GoodsBrandControllerFactory;
use Goods\Controller\Factory\GoodsClassControllerFactory;
use Goods\Controller\Factory\GoodsCommonContentControllerFactory;
use Goods\Controller\Factory\GoodsConsultationControllerFactory;
use Goods\Controller\Factory\GoodsEvaluationControllerFactory;
use Goods\Controller\Factory\GoodsSpecTagControllerFactory;
use Goods\Controller\Factory\GoodsTagControllerFactory;
use Goods\Controller\Factory\GoodsTagGroupControllerFactory;
use Goods\Controller\Factory\IndexControllerFactory;
use Goods\Controller\GoodsAttributeController;
use Goods\Controller\GoodsAttributeGroupController;
use Goods\Controller\GoodsBrandController;
use Goods\Controller\GoodsClassController;
use Goods\Controller\GoodsCommonContentController;
use Goods\Controller\GoodsConsultationController;
use Goods\Controller\GoodsEvaluationController;
use Goods\Controller\GoodsSpecTagController;
use Goods\Controller\GoodsTagController;
use Goods\Controller\GoodsTagGroupController;
use Goods\Controller\IndexController;
use Doctrine\ORM\Mapping\Driver\AnnotationDriver;
use Goods\Event\Factory\GoodsListenerFactory;
use Goods\Event\GoodsListener;
use Goods\Plugin\Factory\GoodsPluginFactory;
use Goods\Plugin\GoodsPlugin;
use Goods\Service\Factory\GoodsAttributeGroupManagerFactory;
use Goods\Service\Factory\GoodsAttributeManagerFactory;
use Goods\Service\Factory\GoodsAttributeValueManagerFactory;
use Goods\Service\Factory\GoodsBrandInClassManagerFactory;
use Goods\Service\Factory\GoodsBrandManagerFactory;
use Goods\Service\Factory\GoodsClassManagerFactory;
use Goods\Service\Factory\GoodsCommonContentManagerFactory;
use Goods\Service\Factory\GoodsConsultationManagerFactory;
use Goods\Service\Factory\GoodsCustomManagerFactory;
use Goods\Service\Factory\GoodsDiscountManagerFactory;
use Goods\Service\Factory\GoodsGroupPriceManagerFactory;
use Goods\Service\Factory\GoodsImageManagerFactory;
use Goods\Service\Factory\GoodsInAttributeManagerFactory;
use Goods\Service\Factory\GoodsInClassManagerFactory;
use Goods\Service\Factory\GoodsInSpecGoodsGroupPriceManagerFactory;
use Goods\Service\Factory\GoodsInSpecGoodsManagerFactory;
use Goods\Service\Factory\GoodsInSpecGroupTagManagerFactory;
use Goods\Service\Factory\GoodsInSpecImageManagerFactory;
use Goods\Service\Factory\GoodsInTagManagerFactory;
use Goods\Service\Factory\GoodsInWholesaleManagerFactory;
use Goods\Service\Factory\GoodsManagerFactory;
use Goods\Service\Factory\GoodsSalesRecordManagerFactory;
use Goods\Service\Factory\GoodsSpecTagGoodsManagerFactory;
use Goods\Service\Factory\GoodsSpecTagManagerFactory;
use Goods\Service\Factory\GoodsStockManagerFactory;
use Goods\Service\Factory\GoodsTagGroupManagerFactory;
use Goods\Service\Factory\GoodsTagManagerFactory;
use Goods\Service\Factory\GoodsVirtualManagerFactory;
use Goods\Service\GoodsAttributeGroupManager;
use Goods\Service\GoodsAttributeManager;
use Goods\Service\GoodsAttributeValueManager;
use Goods\Service\GoodsBrandInClassManager;
use Goods\Service\GoodsBrandManager;
use Goods\Service\GoodsClassManager;
use Goods\Service\GoodsCommonContentManager;
use Goods\Service\GoodsConsultationManager;
use Goods\Service\GoodsCustomManager;
use Goods\Service\GoodsDiscountManager;
use Goods\Service\GoodsGroupPriceManager;
use Goods\Service\GoodsImageManager;
use Goods\Service\GoodsInAttributeManager;
use Goods\Service\GoodsInClassManager;
use Goods\Service\GoodsInSpecGoodsGroupPriceManager;
use Goods\Service\GoodsInSpecGoodsManager;
use Goods\Service\GoodsInSpecGroupTagManager;
use Goods\Service\GoodsInSpecImageManager;
use Goods\Service\GoodsInTagManager;
use Goods\Service\GoodsInWholesaleManager;
use Goods\Service\GoodsManager;
use Goods\Service\GoodsSalesRecordManager;
use Goods\Service\GoodsSpecTagGoodsManager;
use Goods\Service\GoodsSpecTagManager;
use Goods\Service\GoodsStockManager;
use Goods\Service\GoodsTagGroupManager;
use Goods\Service\GoodsTagManager;
use Goods\Service\GoodsVirtualManager;
use Goods\View\Factory\GoodsHelperFactory;
use Goods\View\GoodsHelper;
use Laminas\Router\Http\Segment;

return [
    'router' => [
        'routes' => [
            //商品
            'goods' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/goods[/:action[/:id]]',
                    'defaults' => [
                        'controller' => IndexController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //商品分类
            'goods-class' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/goods-class[/:action[/:id]]',
                    'defaults' => [
                        'controller' => GoodsClassController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //商品品牌
            'goods-brand' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/goods-brand[/:action[/:id]]',
                    'defaults' => [
                        'controller' => GoodsBrandController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //商品标签
            'goods-common' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/goods-common[/:action[/:id]]',
                    'defaults' => [
                        'controller' => GoodsCommonContentController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //商品属性
            'goods-attribute' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/goods-attribute[/:action[/:id[/:vid]]]',
                    'defaults' => [
                        'controller' => GoodsAttributeController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //商品属性分组
            'goods-attribute-group' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/goods-attribute-group[/:action[/:id]]',
                    'defaults' => [
                        'controller' => GoodsAttributeGroupController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //商品标签
            'goods-tag' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/goods-tag[/:action[/:id]]',
                    'defaults' => [
                        'controller' => GoodsTagController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //商品标签组
            'goods-tag-group' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/goods-tag-group[/:action[/:id]]',
                    'defaults' => [
                        'controller' => GoodsTagGroupController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //特定商品标签
            'goods-spec-tag' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/goods-spec-tag[/:action[/:id]]',
                    'defaults' => [
                        'controller' => GoodsSpecTagController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //商品评价
            'goods-evaluation' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/goods-evaluation[/:action[/:id]]',
                    'defaults' => [
                        'controller' => GoodsEvaluationController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            //商品咨询
            'goods-consult' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/goods-consult[/:action[/:id]]',
                    'defaults' => [
                        'controller' => GoodsConsultationController::class,
                        'action'    => 'index'
                    ]
                ]
            ]

        ]

    ],

    'controllers' => [
        'factories' => [
            IndexController::class              => IndexControllerFactory::class,
            GoodsClassController::class         => GoodsClassControllerFactory::class,
            GoodsBrandController::class         => GoodsBrandControllerFactory::class,
            GoodsAttributeController::class     => GoodsAttributeControllerFactory::class,
            GoodsAttributeGroupController::class=> GoodsAttributeGroupControllerFactory::class,
            GoodsTagController::class           => GoodsTagControllerFactory::class,
            GoodsTagGroupController::class      => GoodsTagGroupControllerFactory::class,
            GoodsSpecTagController::class       => GoodsSpecTagControllerFactory::class,
            GoodsConsultationController::class  => GoodsConsultationControllerFactory::class,
            GoodsEvaluationController::class    => GoodsEvaluationControllerFactory::class,
            GoodsCommonContentController::class => GoodsCommonContentControllerFactory::class
        ]
    ],

    'service_manager' => [
        'factories' => [
            GoodsManager::class                 => GoodsManagerFactory::class,
            GoodsCustomManager::class           => GoodsCustomManagerFactory::class,
            GoodsDiscountManager::class         => GoodsDiscountManagerFactory::class,
            GoodsStockManager::class            => GoodsStockManagerFactory::class,
            GoodsImageManager::class            => GoodsImageManagerFactory::class,
            GoodsInClassManager::class          => GoodsInClassManagerFactory::class,
            GoodsInTagManager::class            => GoodsInTagManagerFactory::class,
            GoodsInAttributeManager::class      => GoodsInAttributeManagerFactory::class,
            GoodsInSpecGoodsManager::class      => GoodsInSpecGoodsManagerFactory::class,
            GoodsInSpecGroupTagManager::class   => GoodsInSpecGroupTagManagerFactory::class,
            GoodsGroupPriceManager::class       => GoodsGroupPriceManagerFactory::class,
            GoodsInSpecGoodsGroupPriceManager::class => GoodsInSpecGoodsGroupPriceManagerFactory::class,
            GoodsInSpecImageManager::class      => GoodsInSpecImageManagerFactory::class,
            GoodsInWholesaleManager::class      => GoodsInWholesaleManagerFactory::class,
            GoodsVirtualManager::class          => GoodsVirtualManagerFactory::class,
            GoodsClassManager::class            => GoodsClassManagerFactory::class,
            GoodsBrandManager::class            => GoodsBrandManagerFactory::class,
            GoodsAttributeManager::class        => GoodsAttributeManagerFactory::class,
            GoodsAttributeValueManager::class   => GoodsAttributeValueManagerFactory::class,
            GoodsAttributeGroupManager::class   => GoodsAttributeGroupManagerFactory::class,
            GoodsTagManager::class              => GoodsTagManagerFactory::class,
            GoodsTagGroupManager::class         => GoodsTagGroupManagerFactory::class,
            GoodsSpecTagManager::class          => GoodsSpecTagManagerFactory::class,
            GoodsSpecTagGoodsManager::class     => GoodsSpecTagGoodsManagerFactory::class,
            GoodsBrandInClassManager::class     => GoodsBrandInClassManagerFactory::class,
            GoodsSalesRecordManager::class      => GoodsSalesRecordManagerFactory::class,
            GoodsConsultationManager::class     => GoodsConsultationManagerFactory::class,
            GoodsCommonContentManager::class    => GoodsCommonContentManagerFactory::class,

            GoodsListener::class => GoodsListenerFactory::class
        ]
    ],

    'listeners' => [
        GoodsListener::class
    ],

    'permission_filter' => include __DIR__ . '/permission.php',

    'controller_plugins' => [
        'factories' => [
            GoodsPlugin::class  => GoodsPluginFactory::class
        ],
        'aliases'   => [
            'goodsPlugin'   => GoodsPlugin::class
        ]
    ],

    'view_helpers' => [
        'factories' => [
            GoodsHelper::class  => GoodsHelperFactory::class
        ],
        'aliases' => [
            'goodsHelper'   => GoodsHelper::class
        ],
    ],

    'translator' => [
        'translation_file_patterns' => [
            [
                'type' => 'gettext',
                'base_dir' => __DIR__ . '/../data/language',
                'pattern' => '%s.mo'
            ]
        ]
    ],

    'view_manager' => [
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ]
    ],

    'doctrine' => [
        'driver' => [
            __NAMESPACE__ . '_driver' => [
                'class' => AnnotationDriver::class,
                'cache' => 'array',
                'paths' => [__DIR__ . '/../src/Entity']
            ],
            'orm_default' => [
                'drivers' => [
                    __NAMESPACE__ . '\Entity' => __NAMESPACE__ . '_driver'
                ]
            ]
        ]
    ]
];