<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods;

use Goods\Controller\GoodsAttributeController;
use Goods\Controller\GoodsAttributeGroupController;
use Goods\Controller\GoodsBrandController;
use Goods\Controller\GoodsClassController;
use Goods\Controller\GoodsCommonContentController;
use Goods\Controller\GoodsConsultationController;
use Goods\Controller\GoodsEvaluationController;
use Goods\Controller\GoodsSpecTagController;
use Goods\Controller\GoodsTagController;
use Goods\Controller\GoodsTagGroupController;
use Goods\Controller\IndexController;

return [
    'Goods' => [
        'name' => '商品',
        'controllers' => [
            IndexController::class => [
                'name' => '商品管理',
                'action' => [
                    'index', 'add', 'edit', 'delete', 'editVirtualGoods', 'ajaxUpdateVirtualGoods', 'deleteVirtualGoods', 'importAddMoreVirtualGoods'
                ],
                'actionNames' => [
                    'index'                 => '商品列表',
                    'add'                   => '添加商品',
                    'edit'                  => '编辑商品',
                    'delete'                => '删除商品',
                    'editVirtualGoods'      => '虚拟商品查看与补货',
                    'ajaxUpdateVirtualGoods'=> '虚拟商品添加与编辑',
                    'deleteVirtualGoods'    => '删除虚拟商品',
                    'importAddMoreVirtualGoods' => '批量导入虚拟商品'
                ]
            ],
            GoodsClassController::class => [
                'name' => '分类管理',
                'action' => [
                    'index', 'add', 'edit', 'delete',
                    'updateAllSort', 'updateClassGoods', 'deleteClassGoods'
                ],
                'actionNames' => [
                    'index' => '分类列表',
                    'add'   => '添加分类',
                    'edit'  => '编辑分类',
                    'delete'=> '删除分类',
                    'updateAllSort'     => '批量修改排序',
                    'updateClassGoods'  => '更新分类内商品',
                    'deleteClassGoods'  => '删除分类内商品'
                ]
            ],

            GoodsBrandController::class => [
                'name' => '商品品牌',
                'action' => [
                    'index', 'add', 'edit', 'delete',
                    'updateAllSort', 'deleteBrandGoods'
                ],
                'actionNames' => [
                    'index' => '品牌列表',
                    'add'   => '添加品牌',
                    'edit'  => '编辑品牌',
                    'delete'=> '删除品牌',
                    'updateAllSort'     => '批量修改排序',
                    'deleteBrandGoods'  => '删除品牌内商品'
                ]
            ],

            GoodsCommonContentController::class => [
                'name' => '商品通用内容',
                'action' => ['index', 'add', 'edit', 'delete'],
                'actionNames' => [
                    'index' => '通用内容列表',
                    'add'   => '添加通用内容',
                    'edit'  => '编辑通用内容',
                    'delete'=> '删除通用内容'
                ]
            ],

            GoodsAttributeGroupController::class => [
                'name' => '商品属性组',
                'action' => ['index', 'add', 'edit', 'delete', 'updateAllSort'],
                'actionNames' => [
                    'index' => '属性组列表',
                    'add'   => '添加属性组',
                    'edit'  => '编辑属性组',
                    'delete'=> '删除属性组',
                    'updateAllSort' => '批量修改排序'
                ]
            ],

            GoodsAttributeController::class => [
                'name' => '商品属性',
                'action' => [
                    'index', 'add', 'edit', 'delete', 'updateAllSort',
                    'attributeValue', 'addAttributeValue', 'editAttributeValue', 'deleteAttributeValue', 'updateAttributeValueAll'
                ],
                'actionNames' => [
                    'index' => '属性列表',
                    'add'   => '添加属性',
                    'edit'  => '编辑属性',
                    'delete'=> '删除属性',
                    'updateAllSort' => '批量排序和删除',

                    'attributeValue'    => '属性值列表',
                    'addAttributeValue' => '添加属性值',
                    'editAttributeValue'=> '编辑属性值',
                    'deleteAttributeValue'=> '删除属性值',
                    'updateAttributeValueAll'=> '属性值批量处理'
                ]
            ],

            GoodsTagGroupController::class => [
                'name' => '商品标签分组',
                'action' => ['index', 'add', 'edit', 'delete', 'updateAllSort'],
                'actionNames' => [
                    'index' => '标签组列表',
                    'add'   => '添加标签组',
                    'edit'  => '编辑标签组',
                    'delete'=> '删除标签组',
                    'updateAllSort' => '批量修改排序'
                ]
            ],
            GoodsTagController::class => [
                'name' => '普通商品标签',
                'action' => [
                    'index', 'add', 'edit', 'delete',
                    'updateAllSort', 'addTagGoods', 'deleteTagGoods'
                ],
                'actionNames' => [
                    'index' => '标签列表',
                    'add'   => '添加标签',
                    'edit'  => '编辑标签',
                    'delete'=> '删除标签',
                    'updateAllSort' => '批量排序和删除',
                    'addTagGoods'   => '添加标签商品',
                    'deleteTagGoods'=> '删除标签商品'
                ]
            ],
            GoodsSpecTagController::class => [
                'name' => '特定商品标签',
                'action' => [
                    'index', 'editSpecTagGoods', 'addSpecTagGoods', 'updateSpecTagGoods', 'deleteSpecTagGoods'
                ],
                'actionNames' => [
                    'index'             => '特定标签列表',
                    'editSpecTagGoods'  => '设置商品',
                    'addSpecTagGoods'   => '添加特定标签商品',
                    'updateSpecTagGoods'=> '更新特定标签商品',
                    'deleteSpecTagGoods'=> '删除特定标签商品'
                ]
            ],
            GoodsEvaluationController::class => [
                'name' => '商品评价',
                'action' => [
                    'index', 'showEvaluation', 'replyEvaluation', 'deleteEvaluation'
                ],
                'actionNames' => [
                    'index'             => '评价列表',
                    'showEvaluation'    => '编辑查看',
                    'replyEvaluation'   => '评价回复',
                    'deleteEvaluation'  => '删除评价'
                ]
            ],
            GoodsConsultationController::class => [
                'name' => '商品咨询',
                'action' => [
                    'index', 'replyConsult', 'delete', 'deleteMoreConsultation'
                ],
                'actionNames' => [
                    'index'         => '咨询列表',
                    'replyConsult'  => '回复咨询',
                    'delete'        => '删除咨询',
                    'deleteMoreConsultation' => '批量删除咨询'
                ]
            ]
        ]
    ]
];