<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Controller\Factory;

use Admin\Data\Config;
use Goods\Controller\GoodsAttributeController;
use Goods\Service\GoodsAttributeManager;
use Goods\Service\GoodsAttributeValueManager;
use Goods\Service\GoodsInAttributeManager;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;

class GoodsAttributeControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $goodsAttributeManager = $container->get(GoodsAttributeManager::class);
        $goodsAttributeValueManager = $container->get(GoodsAttributeValueManager::class);
        $goodsInAttributeManager    = $container->get(GoodsInAttributeManager::class);

        return new GoodsAttributeController(
            $translator,
            $entityManager,
            $goodsAttributeManager,
            $goodsAttributeValueManager,
            $goodsInAttributeManager
        );
    }
}