<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Controller\Factory;

use Admin\Data\Config;
use Goods\Controller\GoodsBrandController;
use Goods\Service\GoodsBrandInClassManager;
use Goods\Service\GoodsBrandManager;
use Goods\Service\GoodsManager;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;

class GoodsBrandControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $goodsBrandManager  = $container->get(GoodsBrandManager::class);
        $goodsManager       = $container->get(GoodsManager::class);
        $goodsBrandInClassManager = $container->get(GoodsBrandInClassManager::class);

        return new GoodsBrandController($translator, $entityManager, $goodsBrandManager, $goodsManager, $goodsBrandInClassManager);
    }
}