<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Controller\Factory;

use Admin\Data\Config;
use Goods\Controller\GoodsClassController;
use Goods\Service\GoodsBrandInClassManager;
use Goods\Service\GoodsClassManager;
use Goods\Service\GoodsInClassManager;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;

class GoodsClassControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $goodsClassManager  = $container->get(GoodsClassManager::class);
        $goodsInClassManager= $container->get(GoodsInClassManager::class);
        $goodsBrandInClassManager = $container->get(GoodsBrandInClassManager::class);

        return new GoodsClassController(
            $translator, $entityManager,
            $goodsClassManager,
            $goodsInClassManager,
            $goodsBrandInClassManager
        );
    }
}