<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Controller\Factory;

use Admin\Data\Config;
use Goods\Controller\GoodsEvaluationController;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;
use Sales\Service\OrderGoodsEvaluationBaseManager;
use Sales\Service\OrderGoodsEvaluationManager;
use Sales\Service\OrderGoodsManager;

class GoodsEvaluationControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $orderGoodsEvaluationManager = $container->get(OrderGoodsEvaluationManager::class);
        $orderGoodsEvaluationBaseManager = $container->get(OrderGoodsEvaluationBaseManager::class);
        $orderGoodsManager  = $container->get(OrderGoodsManager::class);

        return new GoodsEvaluationController(
            $translator,
            $entityManager,
            $orderGoodsEvaluationManager,
            $orderGoodsEvaluationBaseManager,
            $orderGoodsManager
        );
    }
}