<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Controller\Factory;

use Admin\Data\Config;
use Goods\Controller\IndexController;
use Goods\Service\GoodsCustomManager;
use Goods\Service\GoodsDiscountManager;
use Goods\Service\GoodsGroupPriceManager;
use Goods\Service\GoodsImageManager;
use Goods\Service\GoodsInAttributeManager;
use Goods\Service\GoodsInClassManager;
use Goods\Service\GoodsInSpecGoodsGroupPriceManager;
use Goods\Service\GoodsInSpecGoodsManager;
use Goods\Service\GoodsInSpecGroupTagManager;
use Goods\Service\GoodsInSpecImageManager;
use Goods\Service\GoodsInTagManager;
use Goods\Service\GoodsInWholesaleManager;
use Goods\Service\GoodsManager;
use Goods\Service\GoodsSalesRecordManager;
use Goods\Service\GoodsStockManager;
use Goods\Service\GoodsVirtualManager;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;

class IndexControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $goodsManager       = $container->get(GoodsManager::class);
        $goodsImageManager  = $container->get(GoodsImageManager::class);
        $goodsStockManager  = $container->get(GoodsStockManager::class);
        $goodsDiscountManager = $container->get(GoodsDiscountManager::class);
        $goodsInClassManager= $container->get(GoodsInClassManager::class);
        $goodsCustomManager = $container->get(GoodsCustomManager::class);
        $goodsInTagManager  = $container->get(GoodsInTagManager::class);
        $goodsInAttributeManager    = $container->get(GoodsInAttributeManager::class);
        $goodsInSpecGroupTagManager = $container->get(GoodsInSpecGroupTagManager::class);
        $goodsInSpecGoodsManager    = $container->get(GoodsInSpecGoodsManager::class);
        $goodsInSpecImageManager    = $container->get(GoodsInSpecImageManager::class);
        $goodsInWholesaleManager    = $container->get(GoodsInWholesaleManager::class);
        $goodsVirtualManager= $container->get(GoodsVirtualManager::class);
        $goodsSalesRecordManager    = $container->get(GoodsSalesRecordManager::class);
        $goodsGroupPriceManager     = $container->get(GoodsGroupPriceManager::class);
        $goodsInSpecGoodsGroupPriceManager = $container->get(GoodsInSpecGoodsGroupPriceManager::class);

        return new IndexController(
            $translator,
            $entityManager,
            $goodsManager,
            $goodsImageManager,
            $goodsStockManager,
            $goodsDiscountManager,
            $goodsInClassManager,
            $goodsCustomManager,
            $goodsInTagManager,
            $goodsInAttributeManager,
            $goodsInSpecGroupTagManager,
            $goodsInSpecGoodsManager,
            $goodsInSpecImageManager,
            $goodsInWholesaleManager,
            $goodsVirtualManager,
            $goodsSalesRecordManager,
            $goodsGroupPriceManager,
            $goodsInSpecGoodsGroupPriceManager
        );
    }
}