<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品基本信息
 * Class Goods
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsRepository")
 * @ORM\Table(name="dbshop_goods")
 */
class Goods extends BaseEntity
{
    /**
     * 商品id
     * @ORM\Id()
     * @ORM\Column(name="goods_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $goodsId;

    /**
     * 商品货号
     * @ORM\Column(name="goods_item", type="string", length=50)
     */
    private $goodsItem;

    /**
     * 分类id, 主分类id
     * @ORM\Column(name="class_id", type="integer", length=11)
     */
    private $classId;

    /**
     * 品牌id
     * @ORM\Column(name="brand_id", type="integer", length=11)
     */
    private $brandId;

    /**
     * 商品名称
     * @ORM\Column(name="goods_name", type="string", length=200)
     */
    private $goodsName;

    /**
     * 商品扩展名称
     * @ORM\Column(name="goods_extend_name", type="string", length=255)
     */
    private $goodsExtendName;

    /**
     * 库存id
     * @ORM\Column(name="stock_id", type="integer", length=11)
     */
    private $stockId;

    /**
     * 商品重量
     * @ORM\Column(name="goods_weight", type="integer", length=11)
     */
    private $goodsWeight;

    /**
     * 重量转换值， goods_weight * goods_weight_conversion = 单个商品重量（克）
     * @ORM\Column(name="goods_weight_conversion", type="integer", length=11)
     */
    private $goodsWeightConversion;

    /**
     * 重量单位
     * @ORM\Column(name="goods_weight_unit", type="string", length=20)
     */
    private $goodsWeightUnit;

    /**
     * 商品关键词SEO
     * @ORM\Column(name="goods_keywords", type="string", length=255)
     */
    private $goodsKeywords;

    /**
     * 商品描述SEO
     * @ORM\Column(name="goods_description", type="string", length=1000)
     */
    private $goodsDescription;

    /**
     * 市场价格
     * @ORM\Column(name="goods_market_price", type="decimal", scale=2)
     */
    private $goodsMarketPrice;

    /**
     * 商品价格
     * @ORM\Column(name="goods_price", type="decimal", scale=2)
     */
    private $goodsPrice;

    /**
     * 商品详情
     * @ORM\Column(name="goods_body", type="text")
     */
    private $goodsBody;

    /**
     * 虚拟销量
     * @ORM\Column(name="virtual_sales", type="integer", length=11)
     */
    private $virtualSales;

    /**
     * 商品状态，1 上架，2 下架
     * @ORM\Column(name="goods_state", type="integer", length=1)
     */
    private $goodsState;

    /**
     * 商品图片id
     * @ORM\Column(name="goods_image_id", type="integer", length=11)
     */
    private $goodsImageId;

    /**
     * 商品类型，1 实物，2 虚拟
     * @ORM\Column(name="goods_type", type="integer", length=1)
     */
    private $goodsType;

    /**
     * 商品标签id字符串
     * @ORM\Column(name="goods_tag_str", type="string", length=1000)
     */
    private $goodsTagStr;

    /**
     * 属性组id
     * @ORM\Column(name="attribute_group_id", type="integer", length=11)
     */
    private $attributeGroupId;

    /**
     * 商品批发状态，0 关闭， 1开启
     * @ORM\Column(name="wholesale_state", type="integer", length=1)
     */
    private $wholesaleState;

    /**
     * 商品积分购买，0 不可购买，1 可购买
     * @ORM\Column(name="goods_integral_buy", type="integer", length=11)
     */
    private $goodsIntegralBuy;

    /**
     * 会员组价格字符串
     * @ORM\Column(name="goods_user_group_price", type="string", length=2000)
     */
    private $goodsUserGroupPrice;

    /**
     * 浏览量
     * @ORM\Column(name="goods_click", type="integer", length=11)
     */
    private $goodsClick;

    /**
     * 商品添加时间
     * @ORM\Column(name="goods_add_time", type="integer", length=10)
     */
    private $goodsAddTime;

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getGoodsItem()
    {
        return $this->goodsItem;
    }

    /**
     * @param mixed $goodsItem
     */
    public function setGoodsItem($goodsItem): void
    {
        $this->goodsItem = $goodsItem;
    }

    /**
     * @return mixed
     */
    public function getClassId()
    {
        return $this->classId;
    }

    /**
     * @param mixed $classId
     */
    public function setClassId($classId): void
    {
        $this->classId = $classId;
    }

    /**
     * @return mixed
     */
    public function getBrandId()
    {
        return $this->brandId;
    }

    /**
     * @param mixed $brandId
     */
    public function setBrandId($brandId): void
    {
        $this->brandId = $brandId;
    }

    /**
     * @return mixed
     */
    public function getGoodsName()
    {
        return $this->goodsName;
    }

    /**
     * @param mixed $goodsName
     */
    public function setGoodsName($goodsName): void
    {
        $this->goodsName = $goodsName;
    }

    /**
     * @return mixed
     */
    public function getGoodsExtendName()
    {
        return $this->goodsExtendName;
    }

    /**
     * @param mixed $goodsExtendName
     */
    public function setGoodsExtendName($goodsExtendName): void
    {
        $this->goodsExtendName = $goodsExtendName;
    }

    /**
     * @return mixed
     */
    public function getStockId()
    {
        return $this->stockId;
    }

    /**
     * @param mixed $stockId
     */
    public function setStockId($stockId): void
    {
        $this->stockId = $stockId;
    }

    /**
     * @return mixed
     */
    public function getGoodsWeight()
    {
        return $this->goodsWeight;
    }

    /**
     * @param mixed $goodsWeight
     */
    public function setGoodsWeight($goodsWeight): void
    {
        $this->goodsWeight = $goodsWeight;
    }

    /**
     * @return mixed
     */
    public function getGoodsWeightConversion()
    {
        return $this->goodsWeightConversion;
    }

    /**
     * @param mixed $goodsWeightConversion
     */
    public function setGoodsWeightConversion($goodsWeightConversion): void
    {
        $this->goodsWeightConversion = $goodsWeightConversion;
    }

    /**
     * @return mixed
     */
    public function getGoodsWeightUnit()
    {
        return $this->goodsWeightUnit;
    }

    /**
     * @param mixed $goodsWeightUnit
     */
    public function setGoodsWeightUnit($goodsWeightUnit): void
    {
        $this->goodsWeightUnit = $goodsWeightUnit;
    }

    /**
     * @return mixed
     */
    public function getGoodsKeywords()
    {
        return $this->goodsKeywords;
    }

    /**
     * @param mixed $goodsKeywords
     */
    public function setGoodsKeywords($goodsKeywords): void
    {
        $this->goodsKeywords = $goodsKeywords;
    }

    /**
     * @return mixed
     */
    public function getGoodsDescription()
    {
        return $this->goodsDescription;
    }

    /**
     * @param mixed $goodsDescription
     */
    public function setGoodsDescription($goodsDescription): void
    {
        $this->goodsDescription = $goodsDescription;
    }

    /**
     * @return mixed
     */
    public function getGoodsMarketPrice()
    {
        return $this->goodsMarketPrice;
    }

    /**
     * @param mixed $goodsMarketPrice
     */
    public function setGoodsMarketPrice($goodsMarketPrice): void
    {
        $this->goodsMarketPrice = $goodsMarketPrice;
    }

    /**
     * @return mixed
     */
    public function getGoodsPrice()
    {
        return $this->goodsPrice;
    }

    /**
     * @param mixed $goodsPrice
     */
    public function setGoodsPrice($goodsPrice): void
    {
        $this->goodsPrice = $goodsPrice;
    }

    /**
     * @return mixed
     */
    public function getGoodsBody()
    {
        return $this->goodsBody;
    }

    /**
     * @param mixed $goodsBody
     */
    public function setGoodsBody($goodsBody): void
    {
        $this->goodsBody = $goodsBody;
    }

    /**
     * @return mixed
     */
    public function getVirtualSales()
    {
        return $this->virtualSales;
    }

    /**
     * @param mixed $virtualSales
     */
    public function setVirtualSales($virtualSales): void
    {
        $this->virtualSales = $virtualSales;
    }

    /**
     * @return mixed
     */
    public function getGoodsState()
    {
        return $this->goodsState;
    }

    /**
     * @param mixed $goodsState
     */
    public function setGoodsState($goodsState): void
    {
        $this->goodsState = $goodsState;
    }

    /**
     * @return mixed
     */
    public function getGoodsImageId()
    {
        return $this->goodsImageId;
    }

    /**
     * @param mixed $goodsImageId
     */
    public function setGoodsImageId($goodsImageId): void
    {
        $this->goodsImageId = $goodsImageId;
    }

    /**
     * @return mixed
     */
    public function getGoodsType()
    {
        return $this->goodsType;
    }

    /**
     * @param mixed $goodsType
     */
    public function setGoodsType($goodsType): void
    {
        $this->goodsType = $goodsType;
    }

    /**
     * @return mixed
     */
    public function getGoodsTagStr()
    {
        return $this->goodsTagStr;
    }

    /**
     * @param mixed $goodsTagStr
     */
    public function setGoodsTagStr($goodsTagStr): void
    {
        $this->goodsTagStr = $goodsTagStr;
    }

    /**
     * @return mixed
     */
    public function getAttributeGroupId()
    {
        return $this->attributeGroupId;
    }

    /**
     * @param mixed $attributeGroupId
     */
    public function setAttributeGroupId($attributeGroupId): void
    {
        $this->attributeGroupId = $attributeGroupId;
    }

    /**
     * @return mixed
     */
    public function getWholesaleState()
    {
        return $this->wholesaleState;
    }

    /**
     * @param mixed $wholesaleState
     */
    public function setWholesaleState($wholesaleState): void
    {
        $this->wholesaleState = $wholesaleState;
    }

    /**
     * @return mixed
     */
    public function getGoodsIntegralBuy()
    {
        return $this->goodsIntegralBuy;
    }

    /**
     * @param mixed $goodsIntegralBuy
     */
    public function setGoodsIntegralBuy($goodsIntegralBuy): void
    {
        $this->goodsIntegralBuy = $goodsIntegralBuy;
    }

    /**
     * @return mixed
     */
    public function getGoodsUserGroupPrice()
    {
        return $this->goodsUserGroupPrice;
    }

    /**
     * @param mixed $goodsUserGroupPrice
     */
    public function setGoodsUserGroupPrice($goodsUserGroupPrice): void
    {
        $this->goodsUserGroupPrice = $goodsUserGroupPrice;
    }

    /**
     * @return mixed
     */
    public function getGoodsClick()
    {
        return $this->goodsClick;
    }

    /**
     * @param mixed $goodsClick
     */
    public function setGoodsClick($goodsClick): void
    {
        $this->goodsClick = $goodsClick;
    }

    /**
     * @return mixed
     */
    public function getGoodsAddTime()
    {
        return $this->goodsAddTime;
    }

    /**
     * @param mixed $goodsAddTime
     */
    public function setGoodsAddTime($goodsAddTime): void
    {
        $this->goodsAddTime = $goodsAddTime;
    }
}