<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品属性
 * Class GoodsAttribute
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsAttributeRepository")
 * @ORM\Table(name="dbshop_goods_attribute")
 */
class GoodsAttribute extends BaseEntity
{
    /**
     * 属性id
     * @ORM\Id()
     * @ORM\Column(name="attribute_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $attributeId;

    /**
     * 属性组id
     * @ORM\Column(name="attribute_group_id", type="integer", length=11)
     */
    private $attributeGroupId;

    /**
     * 属性名称
     * @ORM\Column(name="attribute_name", type="string", length=100)
     */
    private $attributeName;

    /**
     * 属性类型
     * @ORM\Column(name="attribute_type", type="string", length=10)
     */
    private $attributeType;

    /**
     * 属性排序，默认 255
     * @ORM\Column(name="attribute_sort", type="integer", length=11)
     */
    private $attributeSort;

    /**
     * 属性组
     * @ORM\OneToOne(targetEntity="Goods\Entity\GoodsAttributeGroup")
     * @ORM\JoinColumn(name="attribute_group_id", referencedColumnName="attribute_group_id")
     */
    private $oneAttributeGroup;

    /**
     * @return mixed
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }

    /**
     * @param mixed $attributeId
     */
    public function setAttributeId($attributeId): void
    {
        $this->attributeId = $attributeId;
    }

    /**
     * @return mixed
     */
    public function getAttributeGroupId()
    {
        return $this->attributeGroupId;
    }

    /**
     * @param mixed $attributeGroupId
     */
    public function setAttributeGroupId($attributeGroupId): void
    {
        $this->attributeGroupId = $attributeGroupId;
    }

    /**
     * @return mixed
     */
    public function getAttributeName()
    {
        return $this->attributeName;
    }

    /**
     * @param mixed $attributeName
     */
    public function setAttributeName($attributeName): void
    {
        $this->attributeName = $attributeName;
    }

    /**
     * @return mixed
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @param mixed $attributeType
     */
    public function setAttributeType($attributeType): void
    {
        $this->attributeType = $attributeType;
    }

    /**
     * @return mixed
     */
    public function getAttributeSort()
    {
        return $this->attributeSort;
    }

    /**
     * @param mixed $attributeSort
     */
    public function setAttributeSort($attributeSort): void
    {
        $this->attributeSort = $attributeSort;
    }

    /**
     * @return mixed
     */
    public function getOneAttributeGroup()
    {
        return $this->oneAttributeGroup;
    }

    /**
     * @param mixed $oneAttributeGroup
     */
    public function setOneAttributeGroup($oneAttributeGroup): void
    {
        $this->oneAttributeGroup = $oneAttributeGroup;
    }
}