<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品属性分组
 * Class GoodsAttributeGroup
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsAttributeGroupRepository")
 * @ORM\Table(name="dbshop_goods_attribute_group")
 */
class GoodsAttributeGroup extends BaseEntity
{
    /**
     * 属性组id
     * @ORM\Id()
     * @ORM\Column(name="attribute_group_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $attributeGroupId;

    /**
     * 属性组名称
     * @ORM\Column(name="attribute_group_name", type="string", length=100)
     */
    private $attributeGroupName;

    /**
     * 属性组排序，默认 255
     * @ORM\Column(name="attribute_group_sort", type="integer", length=11)
     */
    private $attributeGroupSort;

    /**
     * @return mixed
     */
    public function getAttributeGroupId()
    {
        return $this->attributeGroupId;
    }

    /**
     * @param mixed $attributeGroupId
     */
    public function setAttributeGroupId($attributeGroupId): void
    {
        $this->attributeGroupId = $attributeGroupId;
    }

    /**
     * @return mixed
     */
    public function getAttributeGroupName()
    {
        return $this->attributeGroupName;
    }

    /**
     * @param mixed $attributeGroupName
     */
    public function setAttributeGroupName($attributeGroupName): void
    {
        $this->attributeGroupName = $attributeGroupName;
    }

    /**
     * @return mixed
     */
    public function getAttributeGroupSort()
    {
        return $this->attributeGroupSort;
    }

    /**
     * @param mixed $attributeGroupSort
     */
    public function setAttributeGroupSort($attributeGroupSort): void
    {
        $this->attributeGroupSort = $attributeGroupSort;
    }
}