<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品属性值
 * Class GoodsAttributeValue
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsAttributeValueRepository")
 * @ORM\Table(name="dbshop_goods_attribute_value")
 */
class GoodsAttributeValue extends BaseEntity
{
    /**
     * 属性值id
     * @ORM\Id()
     * @ORM\Column(name="value_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $valueId;

    /**
     * 属性id
     * @ORM\Column(name="attribute_id", type="integer", length=11)
     */
    private $attributeId;

    /**
     * 属性分组
     * @ORM\Column(name="attribute_group_id", type="integer", length=11)
     */
    private $attributeGroupId;

    /**
     * 属性值名称
     * @ORM\Column(name="value_name", type="string", length=100)
     */
    private $valueName;

    /**
     * 属性值排序，默认 255
     * @ORM\Column(name="value_sort", type="integer", length=11)
     */
    private $valueSort;

    /**
     * @return mixed
     */
    public function getValueId()
    {
        return $this->valueId;
    }

    /**
     * @param mixed $valueId
     */
    public function setValueId($valueId): void
    {
        $this->valueId = $valueId;
    }

    /**
     * @return mixed
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }

    /**
     * @param mixed $attributeId
     */
    public function setAttributeId($attributeId): void
    {
        $this->attributeId = $attributeId;
    }

    /**
     * @return mixed
     */
    public function getAttributeGroupId()
    {
        return $this->attributeGroupId;
    }

    /**
     * @param mixed $attributeGroupId
     */
    public function setAttributeGroupId($attributeGroupId): void
    {
        $this->attributeGroupId = $attributeGroupId;
    }

    /**
     * @return mixed
     */
    public function getValueName()
    {
        return $this->valueName;
    }

    /**
     * @param mixed $valueName
     */
    public function setValueName($valueName): void
    {
        $this->valueName = $valueName;
    }

    /**
     * @return mixed
     */
    public function getValueSort()
    {
        return $this->valueSort;
    }

    /**
     * @param mixed $valueSort
     */
    public function setValueSort($valueSort): void
    {
        $this->valueSort = $valueSort;
    }
}