<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品品牌
 * Class GoodsBrand
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsBrandRepository")
 * @ORM\Table(name="dbshop_goods_brand")
 */
class GoodsBrand extends BaseEntity
{
    /**
     * 品牌id
     * @ORM\Id()
     * @ORM\Column(name="brand_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $brandId;

    /**
     * 品牌名称
     * @ORM\Column(name="brand_name", type="string", length=150)
     */
    private $brandName;

    /**
     * 品牌logo
     * @ORM\Column(name="brand_logo", type="string", length=100)
     */
    private $brandLogo;

    /**
     * 品牌简介
     * @ORM\Column(name="brand_info", type="string", length=1000)
     */
    private $brandInfo;

    /**
     * 品牌名称扩展
     * @ORM\Column(name="brand_name_extend", type="string", length=255)
     */
    private $brandNameExtend;

    /**
     * 品牌关键字
     * @ORM\Column(name="brand_keywords", type="string", length=255)
     */
    private $brandKeywords;

    /**
     * 品牌描述
     * @ORM\Column(name="brand_description", type="string", length=1000)
     */
    private $brandDescription;

    /**
     * 品牌排序
     * @ORM\Column(name="brand_sort", type="integer", length=11)
     */
    private $brandSort;

    /**
     * @return mixed
     */
    public function getBrandId()
    {
        return $this->brandId;
    }

    /**
     * @param mixed $brandId
     */
    public function setBrandId($brandId): void
    {
        $this->brandId = $brandId;
    }

    /**
     * @return mixed
     */
    public function getBrandName()
    {
        return $this->brandName;
    }

    /**
     * @param mixed $brandName
     */
    public function setBrandName($brandName): void
    {
        $this->brandName = $brandName;
    }

    /**
     * @return mixed
     */
    public function getBrandLogo()
    {
        return $this->brandLogo;
    }

    /**
     * @param mixed $brandLogo
     */
    public function setBrandLogo($brandLogo): void
    {
        $this->brandLogo = $brandLogo;
    }

    /**
     * @return mixed
     */
    public function getBrandInfo()
    {
        return $this->brandInfo;
    }

    /**
     * @param mixed $brandInfo
     */
    public function setBrandInfo($brandInfo): void
    {
        $this->brandInfo = $brandInfo;
    }

    /**
     * @return mixed
     */
    public function getBrandNameExtend()
    {
        return $this->brandNameExtend;
    }

    /**
     * @param mixed $brandNameExtend
     */
    public function setBrandNameExtend($brandNameExtend): void
    {
        $this->brandNameExtend = $brandNameExtend;
    }

    /**
     * @return mixed
     */
    public function getBrandKeywords()
    {
        return $this->brandKeywords;
    }

    /**
     * @param mixed $brandKeywords
     */
    public function setBrandKeywords($brandKeywords): void
    {
        $this->brandKeywords = $brandKeywords;
    }

    /**
     * @return mixed
     */
    public function getBrandDescription()
    {
        return $this->brandDescription;
    }

    /**
     * @param mixed $brandDescription
     */
    public function setBrandDescription($brandDescription): void
    {
        $this->brandDescription = $brandDescription;
    }

    /**
     * @return mixed
     */
    public function getBrandSort()
    {
        return $this->brandSort;
    }

    /**
     * @param mixed $brandSort
     */
    public function setBrandSort($brandSort): void
    {
        $this->brandSort = $brandSort;
    }
}