<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 品牌所在分类
 * Class GoodsBrandInClass
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsBrandInClassRepository")
 * @ORM\Table(name="dbshop_goods_brand_in_class")
 */
class GoodsBrandInClass extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="in_b_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $inBId;

    /**
     * 商品品牌id
     * @ORM\Column(name="brand_id", type="integer", length=11)
     */
    private $brandId;

    /**
     * 商品分类id
     * @ORM\Column(name="class_id", type="integer", length=11)
     */
    private $classId;

    /**
     * @return mixed
     */
    public function getInBId()
    {
        return $this->inBId;
    }

    /**
     * @param mixed $inBId
     */
    public function setInBId($inBId): void
    {
        $this->inBId = $inBId;
    }

    /**
     * @return mixed
     */
    public function getBrandId()
    {
        return $this->brandId;
    }

    /**
     * @param mixed $brandId
     */
    public function setBrandId($brandId): void
    {
        $this->brandId = $brandId;
    }

    /**
     * @return mixed
     */
    public function getClassId()
    {
        return $this->classId;
    }

    /**
     * @param mixed $classId
     */
    public function setClassId($classId): void
    {
        $this->classId = $classId;
    }
}