<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品分类
 * Class GoodsClass
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsClassRepository")
 * @ORM\Table(name="dbshop_goods_class")
 */
class GoodsClass extends BaseEntity
{
    /**
     * 分类id
     * @ORM\Id()
     * @ORM\Column(name="class_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $classId;

    /**
     * 分类上级id
     * @ORM\Column(name="class_top_id", type="integer", length=11)
     */
    private $classTopId;

    /**
     * 分类名称
     * @ORM\Column(name="class_name", type="string", length=150)
     */
    private $className;

    /**
     * 分类id步长
     * @ORM\Column(name="class_path", type="string", length=255)
     */
    private $classPath;

    /**
     * 分类描述，用于页面显示
     * @ORM\Column(name="class_info", type="string", length=4000)
     */
    private $classInfo;

    /**
     * 分类图片
     * @ORM\Column(name="class_image", type="string", length=100)
     */
    private $classImage;

    /**
     * 分类状态，1 启用，0 禁用
     * @ORM\Column(name="class_state", type="integer", length=1)
     */
    private $classState;

    /**
     * 分类扩展，用于浏览器上标题后面的显示
     * @ORM\Column(name="class_extend", type="string", length=255)
     */
    private $classExtend;

    /**
     * 分类关键词，蛀牙用于搜索引擎
     * @ORM\Column(name="class_keywords", type="string", length=255)
     */
    private $classKeywords;

    /**
     * 分类描述，主要用于搜索引擎
     * @ORM\Column(name="class_description", type="string", length=1000)
     */
    private $classDescription;

    /**
     * 分类可显示的标签组
     * @ORM\Column(name="class_tag_group", type="text")
     */
    private $classTagGroup;

    /**
     * 分类排序，默认 255
     * @ORM\Column(name="class_sort", type="integer", length=11)
     */
    private $classSort;

    /**
     * @return mixed
     */
    public function getClassId()
    {
        return $this->classId;
    }

    /**
     * @param mixed $classId
     */
    public function setClassId($classId): void
    {
        $this->classId = $classId;
    }

    /**
     * @return mixed
     */
    public function getClassTopId()
    {
        return $this->classTopId;
    }

    /**
     * @param mixed $classTopId
     */
    public function setClassTopId($classTopId): void
    {
        $this->classTopId = $classTopId;
    }

    /**
     * @return mixed
     */
    public function getClassName()
    {
        return $this->className;
    }

    /**
     * @param mixed $className
     */
    public function setClassName($className): void
    {
        $this->className = $className;
    }

    /**
     * @return mixed
     */
    public function getClassPath()
    {
        return $this->classPath;
    }

    /**
     * @param mixed $classPath
     */
    public function setClassPath($classPath): void
    {
        $this->classPath = $classPath;
    }

    /**
     * @return mixed
     */
    public function getClassInfo()
    {
        return $this->classInfo;
    }

    /**
     * @param mixed $classInfo
     */
    public function setClassInfo($classInfo): void
    {
        $this->classInfo = $classInfo;
    }

    /**
     * @return mixed
     */
    public function getClassImage()
    {
        return $this->classImage;
    }

    /**
     * @param mixed $classImage
     */
    public function setClassImage($classImage): void
    {
        $this->classImage = $classImage;
    }

    /**
     * @return mixed
     */
    public function getClassState()
    {
        return $this->classState;
    }

    /**
     * @param mixed $classState
     */
    public function setClassState($classState): void
    {
        $this->classState = $classState;
    }

    /**
     * @return mixed
     */
    public function getClassExtend()
    {
        return $this->classExtend;
    }

    /**
     * @param mixed $classExtend
     */
    public function setClassExtend($classExtend): void
    {
        $this->classExtend = $classExtend;
    }

    /**
     * @return mixed
     */
    public function getClassKeywords()
    {
        return $this->classKeywords;
    }

    /**
     * @param mixed $classKeywords
     */
    public function setClassKeywords($classKeywords): void
    {
        $this->classKeywords = $classKeywords;
    }

    /**
     * @return mixed
     */
    public function getClassDescription()
    {
        return $this->classDescription;
    }

    /**
     * @param mixed $classDescription
     */
    public function setClassDescription($classDescription): void
    {
        $this->classDescription = $classDescription;
    }

    /**
     * @return mixed
     */
    public function getClassTagGroup()
    {
        return $this->classTagGroup;
    }

    /**
     * @param mixed $classTagGroup
     */
    public function setClassTagGroup($classTagGroup): void
    {
        $this->classTagGroup = $classTagGroup;
    }

    /**
     * @return mixed
     */
    public function getClassSort()
    {
        return $this->classSort;
    }

    /**
     * @param mixed $classSort
     */
    public function setClassSort($classSort): void
    {
        $this->classSort = $classSort;
    }
}