<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品通用内容
 * Class GoodsCommonContent
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsCommonContentRepository")
 * @ORM\Table(name="dbshop_goods_common_content")
 */
class GoodsCommonContent extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="content_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $contentId;

    /**
     * 商品通用内容简介
     * @ORM\Column(name="content_title", type="string", length=200)
     */
    private $contentTitle;

    /**
     * 商品分类id字符串， 如 ,1,2,3,
     * @ORM\Column(name="class_id_str", type="text")
     */
    private $classIdStr;

    /**
     * 通用内容
     * @ORM\Column(name="content_body", type="text")
     */
    private $contentBody;

    /**
     * 排序，默认255
     * @ORM\Column(name="content_sort", type="integer", length=11)
     */
    private $contentSort;

    /**
     * 状态，1 启用，0 禁用
     * @ORM\Column(name="content_state", type="integer", length=1)
     */
    private $contentState;

    /**
     * @return mixed
     */
    public function getContentId()
    {
        return $this->contentId;
    }

    /**
     * @param mixed $contentId
     */
    public function setContentId($contentId): void
    {
        $this->contentId = $contentId;
    }

    /**
     * @return mixed
     */
    public function getContentTitle()
    {
        return $this->contentTitle;
    }

    /**
     * @param mixed $contentTitle
     */
    public function setContentTitle($contentTitle): void
    {
        $this->contentTitle = $contentTitle;
    }

    /**
     * @return mixed
     */
    public function getClassIdStr()
    {
        return $this->classIdStr;
    }

    /**
     * @param mixed $classIdStr
     */
    public function setClassIdStr($classIdStr): void
    {
        $this->classIdStr = $classIdStr;
    }

    /**
     * @return mixed
     */
    public function getContentBody()
    {
        return $this->contentBody;
    }

    /**
     * @param mixed $contentBody
     */
    public function setContentBody($contentBody): void
    {
        $this->contentBody = $contentBody;
    }

    /**
     * @return mixed
     */
    public function getContentSort()
    {
        return $this->contentSort;
    }

    /**
     * @param mixed $contentSort
     */
    public function setContentSort($contentSort): void
    {
        $this->contentSort = $contentSort;
    }

    /**
     * @return mixed
     */
    public function getContentState()
    {
        return $this->contentState;
    }

    /**
     * @param mixed $contentState
     */
    public function setContentState($contentState): void
    {
        $this->contentState = $contentState;
    }
}