<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品咨询
 * Class GoodsConsultation
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsConsultationRepository")
 * @ORM\Table(name="dbshop_goods_consultation")
 */
class GoodsConsultation extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="consult_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $consultId;

    /**
     * 咨询人id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId = 0;

    /**
     * 咨询人
     * @ORM\Column(name="consult_user", type="string", length=100)
     */
    private $consultUser;

    /**
     * 咨询内容
     * @ORM\Column(name="consult_content", type="string", length=2000)
     */
    private $consultContent;

    /**
     * 咨询时间
     * @ORM\Column(name="consult_time", type="integer", length=10)
     */
    private $consultTime;

    /**
     * 前台显示状态，1 显示，2 不显示
     * @ORM\Column(name="consult_show_status", type="integer", length=1)
     */
    private $consultShowStatus = 2;

    /**
     * 回复内容
     * @ORM\Column(name="reply_content", type="string", length=2000)
     */
    private $replyContent;

    /**
     * 回复时间
     * @ORM\Column(name="reply_time", type="integer", length=10)
     */
    private $replyTime;

    /**
     * 回复人（管理员名称）
     * @ORM\Column(name="reply_user", type="string", length=100)
     */
    private $replyUser;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * @return mixed
     */
    public function getConsultId()
    {
        return $this->consultId;
    }

    /**
     * @param mixed $consultId
     */
    public function setConsultId($consultId): void
    {
        $this->consultId = $consultId;
    }

    /**
     * @return int
     */
    public function getUserId(): int
    {
        return $this->userId;
    }

    /**
     * @param int $userId
     */
    public function setUserId(int $userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getConsultUser()
    {
        return $this->consultUser;
    }

    /**
     * @param mixed $consultUser
     */
    public function setConsultUser($consultUser): void
    {
        $this->consultUser = $consultUser;
    }

    /**
     * @return mixed
     */
    public function getConsultContent()
    {
        return $this->consultContent;
    }

    /**
     * @param mixed $consultContent
     */
    public function setConsultContent($consultContent): void
    {
        $this->consultContent = $consultContent;
    }

    /**
     * @return mixed
     */
    public function getConsultTime()
    {
        return $this->consultTime;
    }

    /**
     * @param mixed $consultTime
     */
    public function setConsultTime($consultTime): void
    {
        $this->consultTime = $consultTime;
    }

    /**
     * @return int
     */
    public function getConsultShowStatus(): int
    {
        return $this->consultShowStatus;
    }

    /**
     * @param int $consultShowStatus
     */
    public function setConsultShowStatus(int $consultShowStatus): void
    {
        $this->consultShowStatus = $consultShowStatus;
    }

    /**
     * @return mixed
     */
    public function getReplyContent()
    {
        return $this->replyContent;
    }

    /**
     * @param mixed $replyContent
     */
    public function setReplyContent($replyContent): void
    {
        $this->replyContent = $replyContent;
    }

    /**
     * @return mixed
     */
    public function getReplyTime()
    {
        return $this->replyTime;
    }

    /**
     * @param mixed $replyTime
     */
    public function setReplyTime($replyTime): void
    {
        $this->replyTime = $replyTime;
    }

    /**
     * @return mixed
     */
    public function getReplyUser()
    {
        return $this->replyUser;
    }

    /**
     * @param mixed $replyUser
     */
    public function setReplyUser($replyUser): void
    {
        $this->replyUser = $replyUser;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }
}