<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品自定义
 * Class GoodsCustom
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsCustomRepository")
 * @ORM\Table(name="dbshop_goods_custom")
 */
class GoodsCustom extends BaseEntity
{
    /**
     * 自定义id
     * @ORM\Id()
     * @ORM\Column(name="custom_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $customId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 自定义标题
     * @ORM\Column(name="custom_title", type="string", length=50)
     */
    private $customTitle;

    /**
     * 自定义内容
     * @ORM\Column(name="custom_content", type="string", length=200)
     */
    private $customContent;

    /**
     * 前台显示，1 显示，2 不显示
     * @ORM\Column(name="front_show", type="integer", length=1)
     */
    private $frontShow;

    /**
     * @ORM\Column(name="custom_key", type="integer", length=2)
     */
    private $customKey;

    /**
     * @return mixed
     */
    public function getCustomId()
    {
        return $this->customId;
    }

    /**
     * @param mixed $customId
     */
    public function setCustomId($customId): void
    {
        $this->customId = $customId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getCustomTitle()
    {
        return $this->customTitle;
    }

    /**
     * @param mixed $customTitle
     */
    public function setCustomTitle($customTitle): void
    {
        $this->customTitle = $customTitle;
    }

    /**
     * @return mixed
     */
    public function getCustomContent()
    {
        return $this->customContent;
    }

    /**
     * @param mixed $customContent
     */
    public function setCustomContent($customContent): void
    {
        $this->customContent = $customContent;
    }

    /**
     * @return mixed
     */
    public function getFrontShow()
    {
        return $this->frontShow;
    }

    /**
     * @param mixed $frontShow
     */
    public function setFrontShow($frontShow): void
    {
        $this->frontShow = $frontShow;
    }

    /**
     * @return mixed
     */
    public function getCustomKey()
    {
        return $this->customKey;
    }

    /**
     * @param mixed $customKey
     */
    public function setCustomKey($customKey): void
    {
        $this->customKey = $customKey;
    }
}