<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品优惠价格
 * Class GoodsDiscount
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsDiscountRepository")
 * @ORM\Table(name="dbshop_goods_discount")
 */
class GoodsDiscount extends BaseEntity
{
    /**
     * 商品优惠自增id
     * @ORM\Id()
     * @ORM\Column(name="discount_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $discountId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 优惠价格
     * @ORM\Column(name="discount_price", type="decimal", scale=2)
     */
    private $discountPrice;

    /**
     * 优惠开始时间，0 不限时间
     * @ORM\Column(name="discount_start_time", type="integer", length=10)
     */
    private $discountStartTime;

    /**
     * 优惠结束时间，0 不限时间
     * @ORM\Column(name="discount_end_time", type="integer", length=10)
     */
    private $discountEndTime;

    /**
     * 优惠会员组类型，allUser 全部，userGroup 个性会员组
     * @ORM\Column(name="discount_user_group_type", type="string", length=20)
     */
    private $discountUserGroupType;

    /**
     * 优惠会员组， all表示全体会员
     * @ORM\Column(name="discount_user_group", type="string", length=2000)
     */
    private $discountUserGroup;

    /**
     * @return mixed
     */
    public function getDiscountId()
    {
        return $this->discountId;
    }

    /**
     * @param mixed $discountId
     */
    public function setDiscountId($discountId): void
    {
        $this->discountId = $discountId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getDiscountPrice()
    {
        return $this->discountPrice;
    }

    /**
     * @param mixed $discountPrice
     */
    public function setDiscountPrice($discountPrice): void
    {
        $this->discountPrice = $discountPrice;
    }

    /**
     * @return mixed
     */
    public function getDiscountStartTime()
    {
        return $this->discountStartTime;
    }

    /**
     * @param mixed $discountStartTime
     */
    public function setDiscountStartTime($discountStartTime): void
    {
        $this->discountStartTime = $discountStartTime;
    }

    /**
     * @return mixed
     */
    public function getDiscountEndTime()
    {
        return $this->discountEndTime;
    }

    /**
     * @param mixed $discountEndTime
     */
    public function setDiscountEndTime($discountEndTime): void
    {
        $this->discountEndTime = $discountEndTime;
    }

    /**
     * @return mixed
     */
    public function getDiscountUserGroupType()
    {
        return $this->discountUserGroupType;
    }

    /**
     * @param mixed $discountUserGroupType
     */
    public function setDiscountUserGroupType($discountUserGroupType): void
    {
        $this->discountUserGroupType = $discountUserGroupType;
    }

    /**
     * @return mixed
     */
    public function getDiscountUserGroup()
    {
        return $this->discountUserGroup;
    }

    /**
     * @param mixed $discountUserGroup
     */
    public function setDiscountUserGroup($discountUserGroup): void
    {
        $this->discountUserGroup = $discountUserGroup;
    }
}