<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品会员组价格（冗余）
 * Class GoodsGroupPrice
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsGroupPriceRepository")
 * @ORM\Table(name="dbshop_goods_group_price")
 */
class GoodsGroupPrice extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="goods_group_price_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $goodsGroupPriceId;

    /**
     * 会员组价格
     * @ORM\Column(name="user_group_price", type="decimal", scale=2)
     */
    private $userGroupPrice;

    /**
     * 会员组id
     * @ORM\Column(name="user_group_id", type="integer", length=11)
     */
    private $userGroupId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * @return mixed
     */
    public function getGoodsGroupPriceId()
    {
        return $this->goodsGroupPriceId;
    }

    /**
     * @param mixed $goodsGroupPriceId
     */
    public function setGoodsGroupPriceId($goodsGroupPriceId): void
    {
        $this->goodsGroupPriceId = $goodsGroupPriceId;
    }

    /**
     * @return mixed
     */
    public function getUserGroupPrice()
    {
        return $this->userGroupPrice;
    }

    /**
     * @param mixed $userGroupPrice
     */
    public function setUserGroupPrice($userGroupPrice): void
    {
        $this->userGroupPrice = $userGroupPrice;
    }

    /**
     * @return mixed
     */
    public function getUserGroupId()
    {
        return $this->userGroupId;
    }

    /**
     * @param mixed $userGroupId
     */
    public function setUserGroupId($userGroupId): void
    {
        $this->userGroupId = $userGroupId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }
}