<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品图片
 * Class GoodsImage
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsImageRepository")
 * @ORM\Table(name="dbshop_goods_image")
 */
class GoodsImage extends BaseEntity
{
    /**
     * 图片自增id
     * @ORM\Id()
     * @ORM\Column(name="goods_image_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $goodsImageId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 商品缩微图
     * @ORM\Column(name="goods_thumbnail_image", type="string", length=200)
     */
    private $goodsThumbnailImage;

    /**
     * 商品图片
     * @ORM\Column(name="goods_image", type="string", length=200)
     */
    private $goodsImage;

    /**
     * 图片切换，1 是， 0 否
     * @ORM\Column(name="image_slide", type="integer", length=1)
     */
    private $imageSlide;

    /**
     * 图片code，用于识别当前的上传用户，其实是当前用户的 session_id
     * @ORM\Column(name="image_code", type="string", length=50)
     */
    private $imageCode;

    /**
     * 图片排序，默认 255
     * @ORM\Column(name="image_sort", type="integer", length=11)
     */
    private $imageSort;

    /**
     * @return mixed
     */
    public function getGoodsImageId()
    {
        return $this->goodsImageId;
    }

    /**
     * @param mixed $goodsImageId
     */
    public function setGoodsImageId($goodsImageId): void
    {
        $this->goodsImageId = $goodsImageId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getGoodsThumbnailImage()
    {
        return $this->goodsThumbnailImage;
    }

    /**
     * @param mixed $goodsThumbnailImage
     */
    public function setGoodsThumbnailImage($goodsThumbnailImage): void
    {
        $this->goodsThumbnailImage = $goodsThumbnailImage;
    }

    /**
     * @return mixed
     */
    public function getGoodsImage()
    {
        return $this->goodsImage;
    }

    /**
     * @param mixed $goodsImage
     */
    public function setGoodsImage($goodsImage): void
    {
        $this->goodsImage = $goodsImage;
    }

    /**
     * @return mixed
     */
    public function getImageSlide()
    {
        return $this->imageSlide;
    }

    /**
     * @param mixed $imageSlide
     */
    public function setImageSlide($imageSlide): void
    {
        $this->imageSlide = $imageSlide;
    }

    /**
     * @return mixed
     */
    public function getImageCode()
    {
        return $this->imageCode;
    }

    /**
     * @param mixed $imageCode
     */
    public function setImageCode($imageCode): void
    {
        $this->imageCode = $imageCode;
    }

    /**
     * @return mixed
     */
    public function getImageSort()
    {
        return $this->imageSort;
    }

    /**
     * @param mixed $imageSort
     */
    public function setImageSort($imageSort): void
    {
        $this->imageSort = $imageSort;
    }
}