<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品关联的属性信息
 * Class GoodsInAttribute
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsInAttributeRepository")
 * @ORM\Table(name="dbshop_goods_in_attribute")
 */
class GoodsInAttribute extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="in_attribute_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $inAttributeId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 属性id
     * @ORM\Column(name="attribute_id", type="integer", length=11)
     */
    private $attributeId;

    /**
     * 属性具体信息
     * @ORM\Column(name="attribute_body", type="string", length=2000)
     */
    private $attributeBody;

    /**
     * @return mixed
     */
    public function getInAttributeId()
    {
        return $this->inAttributeId;
    }

    /**
     * @param mixed $inAttributeId
     */
    public function setInAttributeId($inAttributeId): void
    {
        $this->inAttributeId = $inAttributeId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }

    /**
     * @param mixed $attributeId
     */
    public function setAttributeId($attributeId): void
    {
        $this->attributeId = $attributeId;
    }

    /**
     * @return mixed
     */
    public function getAttributeBody()
    {
        return $this->attributeBody;
    }

    /**
     * @param mixed $attributeBody
     */
    public function setAttributeBody($attributeBody): void
    {
        $this->attributeBody = $attributeBody;
    }
}