<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品所在分类（多分类）
 * Class GoodsInClass
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsInClassRepository")
 * @ORM\Table(name="dbshop_goods_in_class")
 */
class GoodsInClass extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="in_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $inId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 商品分类id
     * @ORM\Column(name="class_id", type="integer", length=11)
     */
    private $classId;

    /**
     * 商品在该分类中的排序
     * @ORM\Column(name="class_goods_sort", type="integer", length=11)
     */
    private $classGoodsSort = 255;

    /**
     * 是否在该分类中推荐该商品
     * @ORM\Column(name="class_goods_recommend", type="integer", length=1)
     */
    private $classGoodsRecommend = 0;

    /**
     * @return mixed
     */
    public function getInId()
    {
        return $this->inId;
    }

    /**
     * @param mixed $inId
     */
    public function setInId($inId): void
    {
        $this->inId = $inId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getClassId()
    {
        return $this->classId;
    }

    /**
     * @param mixed $classId
     */
    public function setClassId($classId): void
    {
        $this->classId = $classId;
    }

    /**
     * @return int
     */
    public function getClassGoodsSort(): int
    {
        return $this->classGoodsSort;
    }

    /**
     * @param int $classGoodsSort
     */
    public function setClassGoodsSort(int $classGoodsSort): void
    {
        $this->classGoodsSort = $classGoodsSort;
    }

    /**
     * @return int
     */
    public function getClassGoodsRecommend(): int
    {
        return $this->classGoodsRecommend;
    }

    /**
     * @param int $classGoodsRecommend
     */
    public function setClassGoodsRecommend(int $classGoodsRecommend): void
    {
        $this->classGoodsRecommend = $classGoodsRecommend;
    }
}