<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品规格商品
 * Class GoodsInSpecGoods
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsInSpecGoodsRepository")
 * @ORM\Table(name="dbshop_goods_in_spec_goods")
 */
class GoodsInSpecGoods extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="in_spec_goods_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $inSpecGoodsId;

    /**
     * 对应的规格字符串
     * @ORM\Column(name="spec_tag_id", type="string", length=1000)
     */
    private $specTagId;

    /**
     * @ORM\Column(name="tag_id_str", type="string", length=100)
     */
    private $tagIdStr;

    /**
     * 规格商品价格
     * @ORM\Column(name="spec_goods_price", type="decimal", scale=2)
     */
    private $specGoodsPrice;

    /**
     * 规格商品库存
     * @ORM\Column(name="spec_goods_stock", type="integer", length=11)
     */
    private $specGoodsStock;

    /**
     * 规格商品货号
     * @ORM\Column(name="spec_goods_item", type="string", length=50)
     */
    private $specGoodsItem;

    /**
     * 规格商品重量
     * @ORM\Column(name="spec_goods_weight", type="integer", length=11)
     */
    private $specGoodsWeight;

    /**
     * 客户组价格
     * @ORM\Column(name="spec_goods_user_group_price", type="string", length=2000)
     */
    private $specGoodsUserGroupPrice;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * @return mixed
     */
    public function getInSpecGoodsId()
    {
        return $this->inSpecGoodsId;
    }

    /**
     * @param mixed $inSpecGoodsId
     */
    public function setInSpecGoodsId($inSpecGoodsId): void
    {
        $this->inSpecGoodsId = $inSpecGoodsId;
    }

    /**
     * @return mixed
     */
    public function getSpecTagId()
    {
        return $this->specTagId;
    }

    /**
     * @param mixed $specTagId
     */
    public function setSpecTagId($specTagId): void
    {
        $this->specTagId = $specTagId;
    }

    /**
     * @return mixed
     */
    public function getTagIdStr()
    {
        return $this->tagIdStr;
    }

    /**
     * @param mixed $tagIdStr
     */
    public function setTagIdStr($tagIdStr): void
    {
        $this->tagIdStr = $tagIdStr;
    }

    /**
     * @return mixed
     */
    public function getSpecGoodsPrice()
    {
        return $this->specGoodsPrice;
    }

    /**
     * @param mixed $specGoodsPrice
     */
    public function setSpecGoodsPrice($specGoodsPrice): void
    {
        $this->specGoodsPrice = $specGoodsPrice;
    }

    /**
     * @return mixed
     */
    public function getSpecGoodsStock()
    {
        return $this->specGoodsStock;
    }

    /**
     * @param mixed $specGoodsStock
     */
    public function setSpecGoodsStock($specGoodsStock): void
    {
        $this->specGoodsStock = $specGoodsStock;
    }

    /**
     * @return mixed
     */
    public function getSpecGoodsItem()
    {
        return $this->specGoodsItem;
    }

    /**
     * @param mixed $specGoodsItem
     */
    public function setSpecGoodsItem($specGoodsItem): void
    {
        $this->specGoodsItem = $specGoodsItem;
    }

    /**
     * @return mixed
     */
    public function getSpecGoodsWeight()
    {
        return $this->specGoodsWeight;
    }

    /**
     * @param mixed $specGoodsWeight
     */
    public function setSpecGoodsWeight($specGoodsWeight): void
    {
        $this->specGoodsWeight = $specGoodsWeight;
    }

    /**
     * @return mixed
     */
    public function getSpecGoodsUserGroupPrice()
    {
        return $this->specGoodsUserGroupPrice;
    }

    /**
     * @param mixed $specGoodsUserGroupPrice
     */
    public function setSpecGoodsUserGroupPrice($specGoodsUserGroupPrice): void
    {
        $this->specGoodsUserGroupPrice = $specGoodsUserGroupPrice;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }
}