<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 规格商品会员组价格（冗余）
 * Class GoodsInSpecGoodsGroupPrice
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsInSpecGoodsGroupPriceRepository")
 * @ORM\Table(name="dbshop_goods_in_spec_goods_group_price")
 */
class GoodsInSpecGoodsGroupPrice extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="spec_goods_group_price_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $specGoodsGroupPriceId;

    /**
     * 会员组价格
     * @ORM\Column(name="user_group_price", type="decimal", scale=2)
     */
    private $userGroupPrice;

    /**
     * 会员组id
     * @ORM\Column(name="user_group_id", type="integer", length=11)
     */
    private $userGroupId;

    /**
     * 规格商品id
     * @ORM\Column(name="in_spec_goods_id", type="integer", length=11)
     */
    private $inSpecGoodsId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * @return mixed
     */
    public function getSpecGoodsGroupPriceId()
    {
        return $this->specGoodsGroupPriceId;
    }

    /**
     * @param mixed $specGoodsGroupPriceId
     */
    public function setSpecGoodsGroupPriceId($specGoodsGroupPriceId): void
    {
        $this->specGoodsGroupPriceId = $specGoodsGroupPriceId;
    }

    /**
     * @return mixed
     */
    public function getUserGroupPrice()
    {
        return $this->userGroupPrice;
    }

    /**
     * @param mixed $userGroupPrice
     */
    public function setUserGroupPrice($userGroupPrice): void
    {
        $this->userGroupPrice = $userGroupPrice;
    }

    /**
     * @return mixed
     */
    public function getUserGroupId()
    {
        return $this->userGroupId;
    }

    /**
     * @param mixed $userGroupId
     */
    public function setUserGroupId($userGroupId): void
    {
        $this->userGroupId = $userGroupId;
    }

    /**
     * @return mixed
     */
    public function getInSpecGoodsId()
    {
        return $this->inSpecGoodsId;
    }

    /**
     * @param mixed $inSpecGoodsId
     */
    public function setInSpecGoodsId($inSpecGoodsId): void
    {
        $this->inSpecGoodsId = $inSpecGoodsId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }
}